/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.scenariogeneration;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataSet;
import net.finmath.smartcontract.simulation.scenariogeneration.MarketDataItem;

public class IRMarketDataParser {
    public static List<IRMarketDataSet> getScenariosFromCSVFile(String fileName) throws IOException {
        CsvMapper mapper = new CsvMapper();
        CsvSchema csvSchema = mapper.typedSchemaFor(MarketDataItem.class).withHeader();
        MappingIterator iterator = mapper.readerFor(MarketDataItem.class).with((FormatSchema)csvSchema).readValues((Reader)new FileReader(fileName));
        List asPojoList = iterator.readAll();
        Map mapCalibDatapointsPerDate = asPojoList.stream().collect(Collectors.groupingBy(MarketDataItem::getScenarioDate, Collectors.groupingBy(MarketDataItem::getCurveKey, Collectors.toSet())));
        List<IRMarketDataSet> scenarioList = null;
        return scenarioList;
    }

    public static final List<IRMarketDataSet> getScenariosFromJsonFile(String fileName) throws IOException {
        String content;
        try {
            content = new String(IRMarketDataParser.class.getResourceAsStream(fileName).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.out.println("Please provide the market data file " + fileName);
            throw e;
        }
        return IRMarketDataParser.getScenariosFromJsonContent(content);
    }

    public static final List<IRMarketDataSet> getScenariosFromJsonString(String jsonString) throws UnsupportedEncodingException, IOException {
        String content = jsonString;
        return IRMarketDataParser.getScenariosFromJsonContent(content);
    }

    private static final List<IRMarketDataSet> getScenariosFromJsonContent(String content) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Map timeSeriesDatamap = (Map)mapper.readValue(content, new HashMap().getClass());
        List<IRMarketDataSet> scenarioList = timeSeriesDatamap.entrySet().stream().map(scenarioData -> {
            Set<CalibrationDatapoint> set = ((Map)scenarioData.getValue()).entrySet().stream().map(entry -> IRMarketDataParser.getCalibrationDataPointSet((String)entry.getKey(), (Map)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toSet());
            String timeStampStr = (String)scenarioData.getKey();
            LocalDateTime dateTime = IRMarketDataParser.parseTimestampString(timeStampStr);
            IRMarketDataSet scenario = new IRMarketDataSet(set, dateTime);
            return scenario;
        }).sorted((scenario1, scenario2) -> scenario1.getDate().compareTo(scenario2.getDate())).collect(Collectors.toList());
        return scenarioList;
    }

    private static Set<CalibrationDatapoint> getCalibrationDataPointSet(String curveKey, Map<String, Map<String, Double>> typeCurveMap) {
        Set<CalibrationDatapoint> datapoints = typeCurveMap.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(curvePointEntry -> new CalibrationDatapoint(curveKey, (String)entry.getKey(), (String)curvePointEntry.getKey(), (Double)curvePointEntry.getValue()))).collect(Collectors.toSet());
        return datapoints;
    }

    private static LocalDateTime parseTimestampString(String timeStampString) {
        LocalDateTime localDateTime;
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        try {
            localDateTime = LocalDateTime.parse(timeStampString, dateTimeFormatter);
        }
        catch (Exception e) {
            LocalDate date = LocalDate.parse(timeStampString, dateFormatter);
            localDateTime = date.atTime(17, 0);
        }
        return localDateTime;
    }
}

