/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.time.LocalDate;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class CalibrationSpecProviderFRA
implements CalibrationSpecProvider {
    private final String tenorLabel;
    private final String maturityLabel;
    private final double fraRate;
    private final String startOffsetLabel;

    public CalibrationSpecProviderFRA(String tenorLabel, String maturityLabel, double fraRate) {
        this.tenorLabel = tenorLabel;
        this.maturityLabel = maturityLabel;
        this.fraRate = fraRate;
        this.startOffsetLabel = maturityLabel.replaceAll("[^0-9]", "") + "m";
    }

    @Override
    public CalibratedCurves.CalibrationSpec getCalibrationSpec(CalibrationContext ctx) {
        Schedule scheduleInterfaceRec = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)this.startOffsetLabel, (String)this.maturityLabel, (String)"tenor", (String)"act/360", (String)"first", (String)"modified_following", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        double calibrationTime = scheduleInterfaceRec.getFixing(scheduleInterfaceRec.getNumberOfPeriods() - 1);
        String curveName = String.format("forward-EUR-%1$s", this.tenorLabel);
        return new CalibratedCurves.CalibrationSpec("EUR-" + this.tenorLabel + this.maturityLabel, "FRA", scheduleInterfaceRec, curveName, this.fraRate, "discount-EUR-OIS", null, "", 0.0, null, curveName, calibrationTime);
    }
}

