/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderDeposit;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderFRA;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderOis;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderSwap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalibrationParserDataPoints
implements CalibrationParser {
    private static final Logger logger = LoggerFactory.getLogger(CalibrationParserDataPoints.class);
    private final Set<String> maturityGrid = new HashSet<String>(Arrays.asList("1W", "2W", "3W", "1M", "2M", "3M", "4M", "5M", "6M", "7M", "8M", "9M", "10M", "11M", "12M", "15M", "18M", "2Y", "3Y", "4Y", "5Y", "6Y", "7Y", "8Y", "9Y", "10Y", "15Y", "20Y", "25Y", "30Y", "40Y", "50Y"));

    @Override
    public Stream<CalibrationSpecProvider> parse(Stream<CalibrationDatapoint> datapoints) {
        return datapoints.map(this::parseDatapointIfPresent).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<CalibrationSpecProvider> parseDatapointIfPresent(CalibrationDatapoint datapoint) {
        if (!this.maturityGrid.contains(datapoint.getMaturity())) {
            return Optional.empty();
        }
        switch (datapoint.getCurveName()) {
            case "ESTR": 
            case "EONIA": {
                if (datapoint.getProductName().equals("Swap-Rate")) {
                    return Optional.of(new CalibrationSpecProviderOis(datapoint.getMaturity(), "annual", datapoint.getQuote()));
                }
                return Optional.empty();
            }
            case "Euribor6M": {
                if (datapoint.getProductName().equalsIgnoreCase("Swap-Rate")) {
                    return Optional.of(new CalibrationSpecProviderSwap("6M", "semiannual", datapoint.getMaturity(), datapoint.getQuote()));
                }
                if (datapoint.getProductName().equalsIgnoreCase("Forward-Rate-Agreement")) {
                    return Optional.of(new CalibrationSpecProviderFRA("6M", datapoint.getMaturity(), datapoint.getQuote()));
                }
                if (datapoint.getProductName().equalsIgnoreCase("Cash")) {
                    return Optional.of(new CalibrationSpecProviderDeposit("6M", datapoint.getMaturity(), datapoint.getQuote()));
                }
                return Optional.empty();
            }
            case "Euribor1M": {
                return Optional.of(new CalibrationSpecProviderSwap("1M", "monthly", datapoint.getMaturity(), datapoint.getQuote()));
            }
            case "Euribor3M": {
                return Optional.of(new CalibrationSpecProviderSwap("3M", "quarterly", datapoint.getMaturity(), datapoint.getQuote()));
            }
        }
        logger.warn("Ignored data point.");
        return Optional.empty();
    }
}

