/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.service.config;

import java.util.ArrayList;
import java.util.List;
import net.finmath.smartcontract.service.utils.ApplicationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableConfigurationProperties(value={ApplicationProperties.class})
public class BasicAuthWebSecurityConfiguration {
    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().anyRequest()).authenticated().and()).httpBasic();
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public InMemoryUserDetailsManager userDetailsService(ApplicationProperties applicationProperties) {
        return new InMemoryUserDetailsManager(this.buildUserDetailsList(applicationProperties));
    }

    private List<UserDetails> buildUserDetailsList(ApplicationProperties applicationProperties) {
        ArrayList<UserDetails> userDetailsList = new ArrayList<UserDetails>();
        applicationProperties.getUsers().forEach(sdcUser -> userDetailsList.add(User.withUsername((String)sdcUser.getUsername()).password("{noop}" + sdcUser.getPassword()).roles(new String[]{sdcUser.getRole()}).build()));
        return userDetailsList;
    }
}

