/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SDCXMLParser {
    private SDCXMLParser() {
    }

    public static SmartDerivativeContractDescriptor parse(String sdcxml) throws ParserConfigurationException, IOException, SAXException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sdcxml.getBytes(StandardCharsets.UTF_8)));
        document.getDocumentElement().normalize();
        String tradeDateString = document.getElementsByTagName("settlementDateInitial").item(0).getTextContent();
        LocalDateTime settlementDateInitial = LocalDateTime.parse(tradeDateString.trim());
        ArrayList<SmartDerivativeContractDescriptor.Party> parties = new ArrayList<SmartDerivativeContractDescriptor.Party>();
        HashMap<String, Double> marginAccountInitialByPartyID = new HashMap<String, Double>();
        HashMap<String, Double> penaltyFeeInitialByPartyID = new HashMap<String, Double>();
        List<Node> partyNodes = SDCXMLParser.nodeChildsByName(document.getElementsByTagName("parties").item(0), "party");
        for (Node partyNode : partyNodes) {
            SmartDerivativeContractDescriptor.Party party = new SmartDerivativeContractDescriptor.Party(SDCXMLParser.nodeValueByName(partyNode, "id", String.class), SDCXMLParser.nodeValueByName(partyNode, "name", String.class), null, SDCXMLParser.nodeValueByName(partyNode, "address", String.class));
            Double marginAccountInitial = SDCXMLParser.nodeValueByName(SDCXMLParser.nodeChildByName(partyNode, "marginAccount"), "value", Double.class);
            Double penaltyFeeInitial = SDCXMLParser.nodeValueByName(SDCXMLParser.nodeChildByName(partyNode, "penaltyFee"), "value", Double.class);
            parties.add(party);
            marginAccountInitialByPartyID.put(party.getId(), marginAccountInitial);
            penaltyFeeInitialByPartyID.put(party.getId(), penaltyFeeInitial);
        }
        String receiverPartyID = document.getElementsByTagName("receiverPartyID").item(0).getTextContent().trim();
        Node underlying = document.getElementsByTagName("underlying").item(0).getFirstChild().getNextSibling();
        return new SmartDerivativeContractDescriptor(settlementDateInitial, parties, marginAccountInitialByPartyID, penaltyFeeInitialByPartyID, receiverPartyID, underlying);
    }

    private static List<Node> nodeChildsByName(Node node, String name) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList childs = node.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node childNode = childs.item(i);
            if (!name.equals(childNode.getNodeName())) continue;
            nodes.add(childNode);
        }
        return nodes;
    }

    private static Node nodeChildByName(Node node, String name) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!name.equals(childNode.getNodeName())) continue;
            return childNode;
        }
        throw new IllegalArgumentException("Node not found");
    }

    private static <T> T nodeValueByName(Node node, String name, Class<T> type) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!name.equals(childNode.getNodeName())) continue;
            String value = childNode.getTextContent();
            if (type.equals(String.class)) {
                return type.cast(value);
            }
            if (type.equals(Double.class)) {
                return type.cast(Double.valueOf(value));
            }
            throw new IllegalArgumentException("Type not supported");
        }
        throw new IllegalArgumentException("Node not found");
    }
}

