/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle.interestrates;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.smartcontract.oracle.ValuationOracle;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParserDataPoints;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.simulation.curvecalibration.Calibrator;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataSet;
import org.javamoney.moneta.Money;

public class ValuationOraclePlainSwap
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final List<IRMarketDataSet> scenarioList;
    private final Swap product;
    private final LocalDate productStartDate;
    private final double notionalAmount;
    private final DoubleUnaryOperator rounding;

    public ValuationOraclePlainSwap(Swap product, double notionalAmount, List<IRMarketDataSet> scenarioList, DoubleUnaryOperator rounding) {
        this.notionalAmount = notionalAmount;
        this.product = product;
        this.productStartDate = ((SwapLeg)this.product.getLegPayer()).getSchedule().getReferenceDate();
        this.scenarioList = scenarioList;
        this.rounding = rounding;
    }

    public ValuationOraclePlainSwap(Swap product, double notionalAmount, List<IRMarketDataSet> scenarioList) {
        this(product, notionalAmount, scenarioList, x -> (double)Math.round(x * 100.0) / 100.0);
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((Number)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }

    @Override
    public Double getValue(LocalDateTime evaluationDate, LocalDateTime marketDataTime) {
        Optional<IRMarketDataSet> optionalScenario = this.scenarioList.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (optionalScenario.isPresent()) {
            IRMarketDataSet scenario2 = optionalScenario.get();
            CalibrationParserDataPoints parser = new CalibrationParserDataPoints();
            Calibrator calibrator = new Calibrator();
            try {
                Optional<CalibrationResult> optionalCalibrationResult = calibrator.calibrateModel(scenario2.getDataAsCalibrationDataPointStream(parser), new CalibrationContextImpl(marketDataTime.toLocalDate(), 1.0E-6));
                AnalyticModel calibratedModel = optionalCalibrationResult.get().getCalibratedModel();
                double evaluationTime = 0.0;
                double valueWithCurves = this.product.getValue(0.0, calibratedModel) * this.notionalAmount;
                calibratedModel = null;
                return this.rounding.applyAsDouble(valueWithCurves);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

