/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.legacy.descriptor.xmlparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.modelling.descriptor.xmlparser.XMLParser;
import net.finmath.smartcontract.legacy.descriptor.TradeDescriptor;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
public class FPMLParserLegacy
implements XMLParser {
    private final String homePartyId;
    private final String discountCurveName;
    private final String forwardCurveName;
    private Document doc;
    private double notional;
    private LocalDate startDate;
    private LocalDate maturityDate;
    private final HashMap productFields = new HashMap();
    private TradeDescriptor tradeDescriptor = null;
    private final ProductDescriptor productDescriptor = null;
    private final AbstractBusinessdayCalendar abstractBusinessdayCalendar = new BusinessdayCalendarExcludingTARGETHolidays();
    private final ScheduleGenerator.ShortPeriodConvention shortPeriodConvention = ScheduleGenerator.ShortPeriodConvention.LAST;

    public FPMLParserLegacy(String homePartyId, String discountCurveName, String forwardCurveName, String fpmlString) throws SAXException, IOException, ParserConfigurationException {
        this.homePartyId = homePartyId;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.parseFPML(fpmlString);
        this.getProductDescriptorFromString(fpmlString);
    }

    public FPMLParserLegacy(String homePartyId, String discountCurveName, String forwardCurveName, File fpmlFile) throws SAXException, IOException, ParserConfigurationException {
        this.homePartyId = homePartyId;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.parseFPML(fpmlFile);
        this.getProductDescriptorFromFile(fpmlFile);
    }

    public FPMLParserLegacy(String homePartyId, String discountCurveName, String forwardCurveName) {
        this.homePartyId = homePartyId;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
    }

    private void parseFPML(File file) throws SAXException, IOException, ParserConfigurationException {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        this.doc.getDocumentElement().normalize();
    }

    private void parseFPML(String fpmlString) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream fpmlInputStream = new ByteArrayInputStream(fpmlString.getBytes());
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fpmlInputStream);
        this.doc.getDocumentElement().normalize();
    }

    private ProductDescriptor getProductDescriptorFromFile(File file) throws SAXException, IOException, ParserConfigurationException {
        ProductDescriptor productDescriptor = this.generateProductDescriptor();
        this.generateTradeDescriptor();
        return productDescriptor;
    }

    private ProductDescriptor getProductDescriptorFromString(String fpmlString) throws SAXException, IOException, ParserConfigurationException {
        this.generateTradeDescriptor();
        return this.generateProductDescriptor();
    }

    public ProductDescriptor getProductDescriptor(Node node) {
        if (!node.getNodeName().equalsIgnoreCase("dataDocument")) {
            throw new IllegalArgumentException("This parser is meant for XML of type dataDocument, according to FpML 5, but file is " + this.doc.getDocumentElement().getNodeName() + ".");
        }
        if (!node.getAttributes().getNamedItem("fpmlVersion").getNodeValue().split("-")[0].equals("5")) {
            throw new IllegalArgumentException("This parser is meant for FpML of version 5.*, file is version " + this.doc.getDocumentElement().getAttribute("fpmlVersion"));
        }
        Element trade = null;
        String tradeName = null;
        NodeList tradeWrapper = node.getOwnerDocument().getElementsByTagName("trade").item(0).getChildNodes();
        for (int index = 0; index < tradeWrapper.getLength(); ++index) {
            if (tradeWrapper.item(index).getNodeType() != 1 || tradeWrapper.item(index).getNodeName().equalsIgnoreCase("tradeHeader")) continue;
            trade = (Element)tradeWrapper.item(index);
            tradeName = trade.getNodeName().toUpperCase();
            break;
        }
        if ("SWAP".equals(tradeName)) {
            return this.getSwapProductDescriptor(trade);
        }
        throw new IllegalArgumentException("This FpML parser is not set up to process trades of type " + tradeName + ".");
    }

    private ProductDescriptor generateProductDescriptor() {
        if (!this.doc.getDocumentElement().getNodeName().equalsIgnoreCase("dataDocument")) {
            throw new IllegalArgumentException("This parser is meant for XML of type dataDocument, according to FpML 5, but file is " + this.doc.getDocumentElement().getNodeName() + ".");
        }
        if (!this.doc.getDocumentElement().getAttribute("fpmlVersion").split("-")[0].equals("5")) {
            throw new IllegalArgumentException("This parser is meant for FpML of version 5.*, file is version " + this.doc.getDocumentElement().getAttribute("fpmlVersion"));
        }
        Element trade = null;
        String tradeName = null;
        NodeList tradeWrapper = this.doc.getElementsByTagName("trade").item(0).getChildNodes();
        for (int index = 0; index < tradeWrapper.getLength(); ++index) {
            if (tradeWrapper.item(index).getNodeType() != 1 || tradeWrapper.item(index).getNodeName().equalsIgnoreCase("tradeHeader")) continue;
            trade = (Element)tradeWrapper.item(index);
            tradeName = trade.getNodeName().toUpperCase();
            break;
        }
        if ("SWAP".equals(tradeName)) {
            return this.getSwapProductDescriptor(trade);
        }
        throw new IllegalArgumentException("This FpML parser is not set up to process trades of type " + tradeName + ".");
    }

    public TradeDescriptor getTradeDescriptor() {
        return this.tradeDescriptor;
    }

    public ProductDescriptor getProductDescriptor() {
        return this.productDescriptor;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getMaturityDate() {
        return this.maturityDate;
    }

    private void generateTradeDescriptor() throws SAXException, IOException, ParserConfigurationException {
        TradeDescriptor tradeDescriptor = new TradeDescriptor();
        String tradeDate = this.doc.getElementsByTagName("tradeDate").item(0).getTextContent();
        tradeDescriptor.setTradeDate(LocalDate.parse(tradeDate));
        NodeList partyTradeIdentifier = this.doc.getElementsByTagName("partyTradeIdentifier");
        String party = null;
        String extRef = null;
        HashMap<String, String> legalEntitiesExternalReferences = new HashMap<String, String>();
        for (int j = 0; j < 2; ++j) {
            NodeList childList = partyTradeIdentifier.item(j).getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (child.getNodeName().equals("partyReference")) {
                    party = ((Element)child).getAttribute("href");
                }
                if (!child.getNodeName().equals("tradeId")) continue;
                extRef = child.getTextContent();
            }
            legalEntitiesExternalReferences.putIfAbsent(party, extRef);
        }
        tradeDescriptor.setLegalEntitiesExternalReferences(legalEntitiesExternalReferences);
        HashMap<String, HashMap<String, String>> legalEntitiesNames = new HashMap<String, HashMap<String, String>>();
        NodeList parties = this.doc.getElementsByTagName("party");
        party = null;
        for (int j = 0; j < 2; ++j) {
            HashMap<String, String> idName = new HashMap<String, String>();
            Node nextParty = parties.item(j);
            party = ((Element)nextParty).getAttribute("id");
            NodeList childList = nextParty.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (!child.getNodeName().contentEquals("partyId") && !child.getNodeName().contentEquals("partyName")) continue;
                idName.putIfAbsent(child.getNodeName(), child.getTextContent());
            }
            legalEntitiesNames.putIfAbsent(party, idName);
        }
        tradeDescriptor.setLegalEntitiesNames(legalEntitiesNames);
        this.tradeDescriptor = tradeDescriptor;
    }

    private ProductDescriptor getSwapProductDescriptor(Element trade) {
        InterestRateSwapLegProductDescriptor legReceiver = null;
        InterestRateSwapLegProductDescriptor legPayer = null;
        NodeList legs = trade.getElementsByTagName("swapStream");
        for (int legIndex = 0; legIndex < legs.getLength(); ++legIndex) {
            Element leg = (Element)legs.item(legIndex);
            boolean isPayer = leg.getElementsByTagName("payerPartyReference").item(0).getAttributes().getNamedItem("href").getNodeValue().equals(this.homePartyId);
            if (isPayer) {
                legPayer = this.getSwapLegProductDescriptor(leg);
                continue;
            }
            legReceiver = this.getSwapLegProductDescriptor(leg);
        }
        return new InterestRateSwapProductDescriptor(legReceiver, legPayer);
    }

    private InterestRateSwapLegProductDescriptor getSwapLegProductDescriptor(Element leg) {
        double _notional;
        boolean isFixed = leg.getElementsByTagName("calculationPeriodDates").item(0).getAttributes().getNamedItem("id").getTextContent().equalsIgnoreCase("fixedCalcPeriodDates");
        LocalDate startDate = LocalDate.parse(((Element)leg.getElementsByTagName("effectiveDate").item(0)).getElementsByTagName("unadjustedDate").item(0).getTextContent());
        LocalDate maturityDate = LocalDate.parse(((Element)leg.getElementsByTagName("terminationDate").item(0)).getElementsByTagName("unadjustedDate").item(0).getTextContent());
        this.startDate = startDate;
        this.maturityDate = maturityDate;
        int fixingOffsetDays = 0;
        if (leg.getElementsByTagName("fixingDates").getLength() > 0) {
            fixingOffsetDays = Integer.parseInt(((Element)leg.getElementsByTagName("fixingDates").item(0)).getElementsByTagName("periodMultiplier").item(0).getTextContent());
        }
        int paymentOffsetDays = 0;
        if (leg.getElementsByTagName("paymentDaysOffset").getLength() > 0) {
            paymentOffsetDays = Integer.parseInt(((Element)leg.getElementsByTagName("paymentDaysOffset").item(0)).getElementsByTagName("periodMultiplier").item(0).getTextContent());
        }
        String xmlInput = ((Element)leg.getElementsByTagName("calculationPeriodDatesAdjustments").item(0)).getElementsByTagName("businessDayConvention").item(0).getTextContent();
        xmlInput = xmlInput.replaceAll("ING", "");
        BusinessdayCalendar.DateRollConvention dateRollConvention = BusinessdayCalendar.DateRollConvention.getEnum((String)xmlInput);
        ScheduleGenerator.DaycountConvention daycountConvention = ScheduleGenerator.DaycountConvention.getEnum((String)leg.getElementsByTagName("dayCountFraction").item(0).getTextContent());
        ScheduleGenerator.Frequency frequency = null;
        Element calcNode = (Element)leg.getElementsByTagName("calculationPeriodFrequency").item(0);
        int multiplier = Integer.parseInt(calcNode.getElementsByTagName("periodMultiplier").item(0).getTextContent());
        switch (calcNode.getElementsByTagName("period").item(0).getTextContent().toUpperCase()) {
            case "D": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.DAILY;
                break;
            }
            case "Y": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            case "M": {
                switch (multiplier) {
                    case 1: {
                        frequency = ScheduleGenerator.Frequency.MONTHLY;
                    }
                    case 3: {
                        frequency = ScheduleGenerator.Frequency.QUARTERLY;
                    }
                    case 6: {
                        frequency = ScheduleGenerator.Frequency.SEMIANNUAL;
                    }
                }
            }
        }
        ScheduleDescriptor schedule = new ScheduleDescriptor(startDate, maturityDate, frequency, daycountConvention, this.shortPeriodConvention, dateRollConvention, this.abstractBusinessdayCalendar, fixingOffsetDays, paymentOffsetDays);
        this.notional = _notional = Double.parseDouble(((Element)leg.getElementsByTagName("notionalSchedule").item(0)).getElementsByTagName("initialValue").item(0).getTextContent());
        double spread = 0.0;
        String forwardCurve = "";
        if (isFixed) {
            spread = Double.parseDouble(((Element)leg.getElementsByTagName("fixedRateSchedule").item(0)).getElementsByTagName("initialValue").item(0).getTextContent());
        } else {
            forwardCurve = this.forwardCurveName;
        }
        return new InterestRateSwapLegProductDescriptor(forwardCurve, this.discountCurveName, schedule, this.notional, spread, false);
    }

    public ProductDescriptor getProductDescriptor(File file) throws SAXException, IOException, ParserConfigurationException {
        return null;
    }
}

