/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo.legacy.chartdatageneration;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import net.finmath.smartcontract.contract.SmartDerivativeContractSchedule;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartData;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartDataGenerator;
import net.finmath.smartcontract.oracle.interestrates.ValuationOraclePlainSwap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtils;

public class ChartDataGeneratorSDCAccountBalance
implements ChartDataGenerator {
    private final Color colorPenalty = new Color(9, 128, 40);
    private final Color colorMarginBuffer = new Color(14, 199, 62);
    private final Color colorXSettlement = new Color(65, 127, 255);
    private final Color colorXPrecheck = new Color(255, 93, 86);
    private final ValuationOraclePlainSwap oracle;
    private final List<LocalDateTime> scenarioDates;
    private SmartDerivativeContractSchedule schedule;
    private final double initialBalance;
    private processStates nextProcessState;
    private LocalDateTime initTime;

    public ChartDataGeneratorSDCAccountBalance(double initialBalance, ValuationOraclePlainSwap oracle, List<LocalDateTime> scenarioDates) {
        this.initialBalance = initialBalance;
        this.oracle = oracle;
        this.scenarioDates = scenarioDates;
        this.nextProcessState = processStates.initialisation;
    }

    @Override
    public ChartData generatedChartData(ActionEvent event) {
        Object data = new double[2][2];
        ArrayList<Color> accountColors = new ArrayList<Color>();
        String title = "Default";
        if (this.initTime == null) {
            data = new double[][]{{this.initialBalance, this.initialBalance}, {0.0, 0.0}};
            this.nextProcessState = processStates.marginCheck;
            this.initTime = LocalDateTime.now();
            ChartData chartData = new ChartData(DatasetUtils.createCategoryDataset((String)"Buffer ", (String)"Bank", (double[][])data));
            title = "Initialisation";
            accountColors.add(this.colorMarginBuffer);
            accountColors.add(this.colorMarginBuffer);
            chartData.addProperty(ChartData.propertyKey.chartTitle, title);
            chartData = chartData.addProperty(ChartData.propertyKey.colorListStackedBar, accountColors);
            this.nextProcessState = processStates.marginCheck;
            return chartData;
        }
        LocalDateTime eventTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(event.getWhen()), ZoneId.systemDefault());
        if (this.nextProcessState == processStates.marginCheck) {
            System.out.println("Current Time Index  = " + eventTime + ": Margin Check");
            LocalDateTime scenarioLast = this.scenarioDates.get(0);
            LocalDateTime scenarioActual = this.scenarioDates.get(1);
            double valueLast = this.oracle.getValue(scenarioLast, scenarioLast);
            double valueActual = this.oracle.getValue(scenarioActual, scenarioActual);
            double value = valueActual - valueLast;
            for (int i = 0; i < ((double[][])data).length; ++i) {
                for (int j = 0; j < ((double[][])data).length; ++j) {
                    if (value < 0.0) {
                        data[0][0] = this.initialBalance + value;
                        data[0][1] = this.initialBalance;
                        data[1][0] = -value;
                    }
                    if (!(value > 0.0)) continue;
                    data[0][0] = this.initialBalance;
                    data[0][1] = this.initialBalance - value;
                    data[1][1] = value;
                }
            }
            title = "1. Margin Check of Booking Amount";
            accountColors.add(this.colorMarginBuffer);
            accountColors.add(this.colorXPrecheck);
            this.nextProcessState = processStates.settlement;
        } else if (this.nextProcessState == processStates.settlement) {
            System.out.println("Current Time = " + eventTime + ": Settlement");
            LocalDateTime scenarioLast = this.scenarioDates.get(0);
            LocalDateTime scenarioActual = this.scenarioDates.get(1);
            double valueLast = this.oracle.getValue(scenarioLast, scenarioLast);
            double valueActual = this.oracle.getValue(scenarioActual, scenarioActual);
            double value = valueActual - valueLast;
            for (int i = 0; i < ((double[][])data).length; ++i) {
                for (int j = 0; j < ((double[][])data).length; ++j) {
                    if (value < 0.0) {
                        data[0][0] = this.initialBalance + value;
                        data[1][0] = 0.0;
                        data[0][1] = this.initialBalance;
                        data[1][1] = -value;
                    }
                    if (!(value > 0.0)) continue;
                    data[0][0] = this.initialBalance;
                    data[1][0] = value;
                    data[0][1] = this.initialBalance - value;
                    data[1][1] = 0.0;
                }
            }
            title = "2. Settlement of Amount X";
            accountColors.add(this.colorMarginBuffer);
            accountColors.add(this.colorXSettlement);
            this.nextProcessState = processStates.refill;
        } else if (this.nextProcessState == processStates.refill) {
            System.out.println("Current Time = " + eventTime + ": Reset");
            for (int i = 0; i < ((double[][])data).length; ++i) {
                for (int j = 0; j < ((double[][])data).length; ++j) {
                    data[0][0] = this.initialBalance;
                    data[0][1] = this.initialBalance;
                    data[1][0] = 0.0;
                    data[1][1] = 0.0;
                }
            }
            title = "3. Refill or Withdraw of Excess Margin";
            accountColors.add(this.colorMarginBuffer);
            accountColors.add(this.colorMarginBuffer);
            this.scenarioDates.remove(0);
            this.nextProcessState = processStates.marginCheck;
        }
        CategoryDataset dataset = DatasetUtils.createCategoryDataset((String)"Buffer ", (String)"Bank", (double[][])data);
        ChartData chartData = new ChartData(dataset);
        chartData.addProperty(ChartData.propertyKey.chartTitle, title);
        chartData = chartData.addProperty(ChartData.propertyKey.colorListStackedBar, accountColors);
        return chartData;
    }

    static enum processStates {
        initialisation,
        marginCheck,
        settlement,
        refill;

    }
}

