/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo.legacy.chartdatageneration;

import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartData;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartDataGenerator;
import net.finmath.smartcontract.oracle.interestrates.ValuationOraclePlainSwap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ChartDataGeneratorMarketValue
implements ChartDataGenerator {
    private final ValuationOraclePlainSwap oracle;
    private final List<LocalDateTime> scenarioDates;
    private final LinkedHashMap<String, Double> dataMap;

    public ChartDataGeneratorMarketValue(ValuationOraclePlainSwap oracle, List<LocalDateTime> scenarioDates) {
        this.oracle = oracle;
        this.scenarioDates = scenarioDates;
        this.dataMap = new LinkedHashMap();
        this.dataMap.put(scenarioDates.get(0).toLocalDate().toString(), this.oracle.getValue(scenarioDates.get(0), scenarioDates.get(0)));
    }

    @Override
    public ChartData generatedChartData(ActionEvent event) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        double marketValue = this.oracle.getValue(this.scenarioDates.get(1), this.scenarioDates.get(1));
        this.dataMap.put(this.scenarioDates.get(1).toLocalDate().toString(), marketValue);
        this.dataMap.entrySet().stream().forEach(entry -> result.addValue((Number)entry.getValue(), (Comparable)((Object)"MarketValue"), (Comparable)entry.getKey()));
        return new ChartData((CategoryDataset)result);
    }
}

