/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo.legacy;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.finmath.marketdata.products.Swap;
import net.finmath.smartcontract.demo.legacy.Visualiser;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartDataGeneratorMarketValue;
import net.finmath.smartcontract.demo.legacy.chartdatageneration.ChartDataGeneratorSDCAccountBalance;
import net.finmath.smartcontract.demo.legacy.plotgeneration.PlotGenerator;
import net.finmath.smartcontract.demo.legacy.plotgeneration.StackedBarchartGenerator;
import net.finmath.smartcontract.demo.legacy.plotgeneration.TimeSeriesChartGenerator;
import net.finmath.smartcontract.oracle.interestrates.ValuationOraclePlainSwap;
import net.finmath.smartcontract.simulation.products.IRSwapGenerator;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataParser;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataSet;

public class DemoLauncher {
    public static void main(String[] args) throws Exception {
        LocalDate startDate = LocalDate.of(2007, 1, 1);
        LocalDate maturity = LocalDate.of(2012, 1, 3);
        String fileName = "timeseriesdatamap.json";
        List scenarioListRaw = IRMarketDataParser.getScenariosFromJsonFile("timeseriesdatamap.json").stream().filter(S -> S.getDate().toLocalDate().isAfter(startDate)).filter(S -> S.getDate().toLocalDate().isBefore(maturity)).collect(Collectors.toList());
        List<IRMarketDataSet> scenarioList = scenarioListRaw.stream().map(scenario -> scenario.getScaled(100.0)).collect(Collectors.toList());
        double notional = 1.0E7;
        String maturityKey = "5Y";
        String forwardCurveKey = "forward-EUR-6M";
        String discountCurveKey = "discount-EUR-OIS";
        LocalDate productStartDate = ((IRMarketDataSet)scenarioList.get(0)).getDate().toLocalDate();
        double fixRate = ((IRMarketDataSet)scenarioList.get(0)).getDataPoints().stream().filter(datapoint -> datapoint.getCurveName().equals("Euribor6M") && datapoint.getProductName().equals("Swap-Rate") && datapoint.getMaturity().equals("5Y")).mapToDouble(e -> e.getQuote()).findAny().getAsDouble();
        Swap swap = IRSwapGenerator.generateAnalyticSwapObject(productStartDate, "5Y", fixRate, true, "forward-EUR-6M", "discount-EUR-OIS");
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(swap, 1.0E7, scenarioList);
        List<LocalDateTime> scenarioDates = scenarioList.stream().map(scenario -> scenario.getDate()).collect(Collectors.toList());
        ChartDataGeneratorSDCAccountBalance chartDataGeneratorSDCAccountBalance = new ChartDataGeneratorSDCAccountBalance(30000.0, oracle, scenarioDates);
        ChartDataGeneratorMarketValue marketValues = new ChartDataGeneratorMarketValue(oracle, scenarioDates);
        StackedBarchartGenerator barchartGenerator = new StackedBarchartGenerator(chartDataGeneratorSDCAccountBalance);
        TimeSeriesChartGenerator timeSeriesChartGenerator = new TimeSeriesChartGenerator(marketValues);
        ArrayList<PlotGenerator> generatorList = new ArrayList<PlotGenerator>();
        generatorList.add(timeSeriesChartGenerator);
        generatorList.add(barchartGenerator);
        Visualiser visualiser = new Visualiser("Smart Contract Simulation", generatorList);
        visualiser.pack();
        visualiser.setVisible(true);
    }
}

