/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Base64;
import net.finmath.smartcontract.model.MarginRequest;
import net.finmath.smartcontract.model.MarginResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ValuationClient {
    private static final Logger logger = LoggerFactory.getLogger(ValuationClient.class);

    public static void main(String[] args) throws Exception {
        String url = "http://localhost:8080";
        String authString = "user1:password1";
        if (args.length != 2) {
            System.out.println("Usage: ValuationClient <url> <user>:<password>");
        }
        if (args.length == 2) {
            authString = args[1];
        } else {
            System.out.println("Using default credentials " + authString);
        }
        if (args.length >= 1) {
            url = args[0];
        } else {
            System.out.println("Using default endpoint " + url);
        }
        String marketDataStart = new String(ValuationClient.class.getClassLoader().getResourceAsStream("net.finmath.smartcontract.client/md_testset1.json").readAllBytes(), StandardCharsets.UTF_8);
        String marketDataEnd = new String(ValuationClient.class.getClassLoader().getResourceAsStream("net.finmath.smartcontract.client/md_testset2.json").readAllBytes(), StandardCharsets.UTF_8);
        String product = new String(ValuationClient.class.getClassLoader().getResourceAsStream("net.finmath.smartcontract.client/smartderivativecontract-sample-swap.xml").readAllBytes(), StandardCharsets.UTF_8);
        MarginRequest marginRequest = new MarginRequest().marketDataStart(marketDataStart).marketDataEnd(marketDataEnd).tradeData(product).valuationDate(LocalDateTime.now().toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", "Basic " + base64Creds);
        RequestEntity requestEntity = new RequestEntity((Object)marginRequest, (MultiValueMap)headers, HttpMethod.POST, new URI(url + "/valuation/margin"), MarginRequest.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, MarginResult.class);
        MarginResult result = (MarginResult)response.getBody();
        System.out.println("Received the valuation result:\n" + result);
        ValuationClient.printInfoGit(url, authString);
        ValuationClient.printInfoFinmath(url, authString);
    }

    private static void printInfoGit(String url, String authString) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", "Basic " + base64Creds);
        RequestEntity requestEntity = new RequestEntity(null, (MultiValueMap)headers, HttpMethod.GET, new URI(url + "/info/git"), String.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, String.class);
        System.out.println();
        System.out.println("git status");
        System.out.println((String)response.getBody());
    }

    private static void printInfoFinmath(String url, String authString) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String base64Creds = Base64.getEncoder().encodeToString(authString.getBytes());
        headers.add("Authorization", "Basic " + base64Creds);
        RequestEntity requestEntity = new RequestEntity(null, (MultiValueMap)headers, HttpMethod.GET, new URI(url + "/info/finmath"), String.class);
        ResponseEntity response = new RestTemplate().exchange(requestEntity, String.class);
        System.out.println();
        System.out.println("finmath-lib version");
        System.out.println((String)response.getBody());
    }
}

