/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import net.finmath.smartcontract.model.Error;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="info", description="the info API")
public interface InfoApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="infoFinmath", summary="Request info on finmath-lib version and tags", responses={@ApiResponse(responseCode="200", description="Info returned", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/info/finmath"}, produces={"application/json"})
    default public ResponseEntity<String> _infoFinmath() {
        return this.infoFinmath();
    }

    default public ResponseEntity<String> infoFinmath() {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="infoGit", summary="Request info on Git version and tags", responses={@ApiResponse(responseCode="200", description="Info returned", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="200", description="unexpected error", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/info/git"}, produces={"application/json"})
    default public ResponseEntity<String> _infoGit() {
        return this.infoGit();
    }

    default public ResponseEntity<String> infoGit() {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

