package net.finmath.smartcontract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ValueResult
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-11-06T20:18:56.336962+01:00[Europe/Berlin]")
public class ValueResult {

  @JsonProperty("value")
  private BigDecimal value;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("valuationDate")
  private String valuationDate;

  public ValueResult value(BigDecimal value) {
    this.value = value;
    return this;
  }

  /**
   * Get value
   * @return value
  */
  @NotNull @Valid 
  @Schema(name = "value", required = true)
  public BigDecimal getValue() {
    return value;
  }

  public void setValue(BigDecimal value) {
    this.value = value;
  }

  public ValueResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
  */
  @NotNull 
  @Schema(name = "currency", required = true)
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public ValueResult valuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
    return this;
  }

  /**
   * Get valuationDate
   * @return valuationDate
  */
  @NotNull 
  @Schema(name = "valuationDate", required = true)
  public String getValuationDate() {
    return valuationDate;
  }

  public void setValuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValueResult valueResult = (ValueResult) o;
    return Objects.equals(this.value, valueResult.value) &&
        Objects.equals(this.currency, valueResult.currency) &&
        Objects.equals(this.valuationDate, valueResult.valuationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, currency, valuationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValueResult {\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    valuationDate: ").append(toIndentedString(valuationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

