package net.finmath.smartcontract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ValueRequest
 */

@JsonTypeName("value_request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-11-06T20:18:56.336962+01:00[Europe/Berlin]")
public class ValueRequest {

  @JsonProperty("marketData")
  private String marketData;

  @JsonProperty("tradeData")
  private String tradeData;

  @JsonProperty("valuationDate")
  private String valuationDate;

  public ValueRequest marketData(String marketData) {
    this.marketData = marketData;
    return this;
  }

  /**
   * Get marketData
   * @return marketData
  */
  
  @Schema(name = "marketData", required = false)
  public String getMarketData() {
    return marketData;
  }

  public void setMarketData(String marketData) {
    this.marketData = marketData;
  }

  public ValueRequest tradeData(String tradeData) {
    this.tradeData = tradeData;
    return this;
  }

  /**
   * Get tradeData
   * @return tradeData
  */
  @NotNull 
  @Schema(name = "tradeData", required = true)
  public String getTradeData() {
    return tradeData;
  }

  public void setTradeData(String tradeData) {
    this.tradeData = tradeData;
  }

  public ValueRequest valuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
    return this;
  }

  /**
   * Get valuationDate
   * @return valuationDate
  */
  @NotNull 
  @Schema(name = "valuationDate", required = true)
  public String getValuationDate() {
    return valuationDate;
  }

  public void setValuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValueRequest valueRequest = (ValueRequest) o;
    return Objects.equals(this.marketData, valueRequest.marketData) &&
        Objects.equals(this.tradeData, valueRequest.tradeData) &&
        Objects.equals(this.valuationDate, valueRequest.valuationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(marketData, tradeData, valuationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ValueRequest {\n");
    sb.append("    marketData: ").append(toIndentedString(marketData)).append("\n");
    sb.append("    tradeData: ").append(toIndentedString(tradeData)).append("\n");
    sb.append("    valuationDate: ").append(toIndentedString(valuationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

