package net.finmath.smartcontract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * MarginRequest
 */

@JsonTypeName("margin_request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-11-06T20:18:56.336962+01:00[Europe/Berlin]")
public class MarginRequest {

  @JsonProperty("marketDataStart")
  private String marketDataStart;

  @JsonProperty("marketDataEnd")
  private String marketDataEnd;

  @JsonProperty("tradeData")
  private String tradeData;

  @JsonProperty("valuationDate")
  private String valuationDate;

  public MarginRequest marketDataStart(String marketDataStart) {
    this.marketDataStart = marketDataStart;
    return this;
  }

  /**
   * Get marketDataStart
   * @return marketDataStart
  */
  @NotNull 
  @Schema(name = "marketDataStart", required = true)
  public String getMarketDataStart() {
    return marketDataStart;
  }

  public void setMarketDataStart(String marketDataStart) {
    this.marketDataStart = marketDataStart;
  }

  public MarginRequest marketDataEnd(String marketDataEnd) {
    this.marketDataEnd = marketDataEnd;
    return this;
  }

  /**
   * Get marketDataEnd
   * @return marketDataEnd
  */
  @NotNull 
  @Schema(name = "marketDataEnd", required = true)
  public String getMarketDataEnd() {
    return marketDataEnd;
  }

  public void setMarketDataEnd(String marketDataEnd) {
    this.marketDataEnd = marketDataEnd;
  }

  public MarginRequest tradeData(String tradeData) {
    this.tradeData = tradeData;
    return this;
  }

  /**
   * Get tradeData
   * @return tradeData
  */
  @NotNull 
  @Schema(name = "tradeData", required = true)
  public String getTradeData() {
    return tradeData;
  }

  public void setTradeData(String tradeData) {
    this.tradeData = tradeData;
  }

  public MarginRequest valuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
    return this;
  }

  /**
   * Get valuationDate
   * @return valuationDate
  */
  @NotNull 
  @Schema(name = "valuationDate", required = true)
  public String getValuationDate() {
    return valuationDate;
  }

  public void setValuationDate(String valuationDate) {
    this.valuationDate = valuationDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MarginRequest marginRequest = (MarginRequest) o;
    return Objects.equals(this.marketDataStart, marginRequest.marketDataStart) &&
        Objects.equals(this.marketDataEnd, marginRequest.marketDataEnd) &&
        Objects.equals(this.tradeData, marginRequest.tradeData) &&
        Objects.equals(this.valuationDate, marginRequest.valuationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(marketDataStart, marketDataEnd, tradeData, valuationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MarginRequest {\n");
    sb.append("    marketDataStart: ").append(toIndentedString(marketDataStart)).append("\n");
    sb.append("    marketDataEnd: ").append(toIndentedString(marketDataEnd)).append("\n");
    sb.append("    tradeData: ").append(toIndentedString(tradeData)).append("\n");
    sb.append("    valuationDate: ").append(toIndentedString(valuationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

