/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.0.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package net.finmath.smartcontract.api;

import net.finmath.smartcontract.model.Error;
import net.finmath.smartcontract.model.MarginRequest;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.ValueRequest;
import net.finmath.smartcontract.model.ValueResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-11-06T20:18:56.336962+01:00[Europe/Berlin]")
@Validated
@Tag(name = "valuation", description = "the valuation API")
public interface ValuationApi {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * POST /valuation/margin : Request mapping for the margin
     *
     * @param marginRequest  (optional)
     * @return Margin was calculated (status code 200)
     *         or unexpected error (status code 200)
     */
    @Operation(
        operationId = "margin",
        summary = "Request mapping for the margin",
        responses = {
            @ApiResponse(responseCode = "200", description = "Margin was calculated", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = MarginResult.class))
            }),
            @ApiResponse(responseCode = "200", description = "unexpected error", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/valuation/margin",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default ResponseEntity<MarginResult> _margin(
        @Parameter(name = "MarginRequest", description = "") @Valid @RequestBody(required = false) MarginRequest marginRequest
    ) {
        return margin(marginRequest);
    }

    // Override this method
    default  ResponseEntity<MarginResult> margin(MarginRequest marginRequest) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                    String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }


    /**
     * POST /valuation/test/product : Request mapping for the value of a product (using fixed market data)
     *
     * @param tradeData  (required)
     * @return Value was calculated (status code 200)
     *         or unexpected error (status code 200)
     */
    @Operation(
        operationId = "testProductValue",
        summary = "Request mapping for the value of a product (using fixed market data)",
        responses = {
            @ApiResponse(responseCode = "200", description = "Value was calculated", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ValueResult.class))
            }),
            @ApiResponse(responseCode = "200", description = "unexpected error", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/valuation/test/product",
        produces = { "application/json" },
        consumes = { "multipart/form-data" }
    )
    default ResponseEntity<ValueResult> _testProductValue(
        @Parameter(name = "tradeData", description = "", required = true) @RequestPart(value = "tradeData", required = true) MultipartFile tradeData
    ) {
        return testProductValue(tradeData);
    }

    // Override this method
    default  ResponseEntity<ValueResult> testProductValue(MultipartFile tradeData) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                    String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }


    /**
     * POST /valuation/value : Request mapping for the value
     *
     * @param valueRequest  (optional)
     * @return Value was calculated (status code 200)
     *         or unexpected error (status code 200)
     */
    @Operation(
        operationId = "value",
        summary = "Request mapping for the value",
        responses = {
            @ApiResponse(responseCode = "200", description = "Value was calculated", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ValueResult.class))
            }),
            @ApiResponse(responseCode = "200", description = "unexpected error", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/valuation/value",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default ResponseEntity<ValueResult> _value(
        @Parameter(name = "ValueRequest", description = "") @Valid @RequestBody(required = false) ValueRequest valueRequest
    ) {
        return value(valueRequest);
    }

    // Override this method
    default  ResponseEntity<ValueResult> value(ValueRequest valueRequest) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                    String exampleString = "{ \"valuationDate\" : \"valuationDate\", \"currency\" : \"currency\", \"value\" : 0.8008281904610115 }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
