/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.scenariogeneration;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.finmath.smartcontract.simulation.scenariogeneration.IRCurveData;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataScenario;

public class IRScenarioGenerator {
    public static final List<IRMarketDataScenario> getScenariosFromJsonFile(String fileName, DateTimeFormatter dateFormatter) throws UnsupportedEncodingException, IOException {
        String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])), "UTF-8");
        Gson gson = new Gson();
        Map timeSeriesDatamap = (Map)gson.fromJson(content, new HashMap().getClass());
        List<IRMarketDataScenario> scenarioList = timeSeriesDatamap.entrySet().stream().map(scenarioData -> {
            Map<String, IRCurveData> map = ((Map)scenarioData.getValue()).entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> new IRCurveData((String)entry.getKey(), (Map)entry.getValue())));
            String dateString = (String)scenarioData.getKey();
            LocalDate date = LocalDate.parse(dateString, dateFormatter);
            LocalDateTime dateTime = date.atTime(17, 0);
            IRMarketDataScenario scenario = new IRMarketDataScenario(map, dateTime);
            return scenario;
        }).sorted((scenario1, scenario2) -> scenario1.getDate().compareTo(scenario2.getDate())).collect(Collectors.toList());
        return scenarioList;
    }
}

