/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.time.LocalDate;
import java.util.Optional;
import java.util.stream.Stream;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterpolation;
import net.finmath.optimizer.SolverException;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class Calibrator {
    public static final String DISCOUNT_EUR_OIS = "discount-EUR-OIS";

    public Optional<CalibrationResult> calibrateModel(Stream<CalibrationSpecProvider> providers, CalibrationContext ctx) throws CloneNotSupportedException {
        AnalyticModelFromCurvesAndVols model = new AnalyticModelFromCurvesAndVols(this.getCalibrationCurves(ctx));
        CalibratedCurves.CalibrationSpec[] specs = (CalibratedCurves.CalibrationSpec[])providers.map(c -> c.getCalibrationSpec(ctx)).toArray(CalibratedCurves.CalibrationSpec[]::new);
        try {
            return Optional.of(new CalibrationResult(new CalibratedCurves(specs, model, ctx.getAccuracy()), specs));
        }
        catch (SolverException e) {
            return Optional.empty();
        }
    }

    private Curve[] getCalibrationCurves(CalibrationContext ctx) {
        return new Curve[]{this.getOisDiscountCurve(ctx), this.getOisForwardCurve(ctx), this.get1MForwardCurve(ctx), this.get3MForwardCurve(ctx), this.get6MForwardCurve(ctx)};
    }

    private DiscountCurveInterpolation getOisDiscountCurve(CalibrationContext ctx) {
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors((String)DISCOUNT_EUR_OIS, (LocalDate)ctx.getReferenceDate(), (double[])new double[]{0.0}, (double[])new double[]{1.0}, (boolean[])new boolean[]{false}, (CurveInterpolation.InterpolationMethod)CurveInterpolation.InterpolationMethod.LINEAR, (CurveInterpolation.ExtrapolationMethod)CurveInterpolation.ExtrapolationMethod.CONSTANT, (CurveInterpolation.InterpolationEntity)CurveInterpolation.InterpolationEntity.LOG_OF_VALUE);
    }

    private ForwardCurve getOisForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveFromDiscountCurve("forward-EUR-OIS", DISCOUNT_EUR_OIS, ctx.getReferenceDate(), "3M");
    }

    private ForwardCurve get3MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveInterpolation("forward-EUR-3M", ctx.getReferenceDate(), "3M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }

    private ForwardCurve get6MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveInterpolation("forward-EUR-6M", ctx.getReferenceDate(), "6M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }

    private ForwardCurve get1MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveInterpolation("forward-EUR-1M", ctx.getReferenceDate(), "1M", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }
}

