/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderOis;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProviderSwap;

public class CalibrationParserDataPoints
implements CalibrationParser {
    private final Set<String> maturityGrid = new HashSet<String>(Arrays.asList("1W", "2W", "3W", "1M", "2M", "3M", "4M", "5M", "6M", "7M", "8M", "9M", "10M", "11M", "12M", "15M", "18M", "2Y", "3Y", "4Y", "5Y", "6Y", "7Y", "8Y", "9Y", "10Y", "15Y", "20Y", "25Y", "30Y", "40Y", "50Y"));

    @Override
    public Stream<CalibrationSpecProvider> parse(Stream<CalibrationDatapoint> datapoints) {
        return datapoints.flatMap(d -> Streams.stream(this.parseDatapointIfPresent((CalibrationDatapoint)d)));
    }

    private Optional<CalibrationSpecProvider> parseDatapointIfPresent(CalibrationDatapoint datapoint) {
        if (!this.maturityGrid.contains(datapoint.getMaturity())) {
            return Optional.empty();
        }
        switch (datapoint.getCurveName()) {
            case "EONIA": {
                return Optional.of(new CalibrationSpecProviderOis(datapoint.getMaturity(), "annual", datapoint.getQuote() / 100.0));
            }
            case "Euribor1M": {
                return Optional.of(new CalibrationSpecProviderSwap("1M", "monthly", datapoint.getMaturity(), datapoint.getQuote() / 100.0));
            }
            case "Euribor3M": {
                return Optional.of(new CalibrationSpecProviderSwap("3M", "quarterly", datapoint.getMaturity(), datapoint.getQuote() / 100.0));
            }
            case "Euribor6M": {
                return Optional.of(new CalibrationSpecProviderSwap("6M", "semiannual", datapoint.getMaturity(), datapoint.getQuote() / 100.0));
            }
        }
        return Optional.empty();
    }
}

