/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.smartcontract.oracle.ValuationOracle;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParserDataPoints;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.simulation.curvecalibration.Calibrator;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataScenario;
import org.javamoney.moneta.Money;

public class ValuationOraclePlainSwapHistoricScenarios
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final List<IRMarketDataScenario> scenarioList;
    private final Swap product;
    private final LocalDate productStartDate;
    private final double notionalAmount;

    public ValuationOraclePlainSwapHistoricScenarios(Swap product, double notionalAmount, List<IRMarketDataScenario> scenarioList) {
        this.notionalAmount = notionalAmount;
        this.product = product;
        this.productStartDate = ((SwapLeg)this.product.getLegPayer()).getSchedule().getReferenceDate();
        this.scenarioList = scenarioList;
    }

    @Override
    public Double getValue(LocalDateTime evaluationDate, LocalDateTime marketDataTime) {
        Optional<IRMarketDataScenario> optionalScenario = this.scenarioList.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (optionalScenario.isPresent()) {
            IRMarketDataScenario scenario2 = optionalScenario.get();
            CalibrationParserDataPoints parser = new CalibrationParserDataPoints();
            Calibrator calibrator = new Calibrator();
            try {
                Optional<CalibrationResult> optionalCalibrationResult = calibrator.calibrateModel(scenario2.getDataAsCalibrationDataProintStream(parser), new CalibrationContextImpl(marketDataTime.toLocalDate(), 1.0E-6));
                AnalyticModel calibratedModel = optionalCalibrationResult.get().getCalibratedModel();
                double evaluationTime = 0.0;
                double valueWithCurves = this.product.getValue(0.0, calibratedModel) * this.notionalAmount;
                calibratedModel = null;
                return valueWithCurves;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((Number)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }
}

