/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle;

import java.time.LocalDateTime;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionLazyInit;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.smartcontract.oracle.StochasticValuationOracle;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class GeometricBrownianMotionOracle
implements StochasticValuationOracle {
    private final TimeDiscretization timeDiscretization;
    private final LocalDateTime initialTime;
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final int numberOfPaths;
    private transient MonteCarloAssetModel simulation;
    private final Object simulationLazyInitLock = new Object();

    public GeometricBrownianMotionOracle() {
        this(LocalDateTime.now());
    }

    public GeometricBrownianMotionOracle(LocalDateTime initialTime) {
        this(initialTime, 1.0, 20.0, 0.02, 0.1, 1000);
    }

    public GeometricBrownianMotionOracle(LocalDateTime initialTime, double initialValue, double timeHorizon, double riskFreeRate, double volatility, int numberOfPaths) {
        this((TimeDiscretization)new TimeDiscretizationFromArray(0.0, timeHorizon, 0.0027397260273972603, TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, initialValue, riskFreeRate, volatility, numberOfPaths);
    }

    public GeometricBrownianMotionOracle(TimeDiscretization timeDiscretization, LocalDateTime initialTime, double initialValue, double riskFreeRate, double volatility, int numberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.initialTime = initialTime;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.numberOfPaths = numberOfPaths;
    }

    private void init() {
        boolean numberOfFactors = true;
        int seed = 31415;
        this.simulation = new MonteCarloAssetModel((ProcessModel)new BlackScholesModel(this.initialValue, this.riskFreeRate, this.volatility), (MonteCarloProcess)new EulerSchemeFromProcessModel((IndependentIncrements)new BrownianMotionLazyInit(this.timeDiscretization, 1, this.numberOfPaths, 31415)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getValue(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        Object object = this.simulationLazyInitLock;
        synchronized (object) {
            if (this.simulation == null) {
                this.init();
            }
        }
        double time = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.initialTime, (LocalDateTime)marketDataTime);
        int timeIndexOfLastFixing = this.timeDiscretization.getTimeIndexNearestLessOrEqual(time);
        double timeOfLastFixing = this.timeDiscretization.getTime(timeIndexOfLastFixing);
        RandomVariable value = null;
        try {
            value = this.simulation.getAssetValue(timeOfLastFixing, 0);
        }
        catch (CalculationException e) {
            Logger.getLogger("net.finmath.smartcontract").warning("Oracle valuation failed with " + e.getCause());
        }
        return value;
    }
}

