/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo.plotgeneration;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.util.List;
import net.finmath.smartcontract.demo.chartdatageneration.ChartData;
import net.finmath.smartcontract.demo.chartdatageneration.ChartDataGenerator;
import net.finmath.smartcontract.demo.plotgeneration.PlotGenerator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;

public class StackedBarchartGenerator
implements PlotGenerator {
    private final ChartDataGenerator chartDataGenerator;
    private final Color backGroundPaintColor = new Color(249, 231, 236);

    public StackedBarchartGenerator(ChartDataGenerator chartDataGenerator) {
        this.chartDataGenerator = chartDataGenerator;
    }

    @Override
    public CategoryPlot createPlot(ActionEvent e) {
        ChartData chartData = this.chartDataGenerator.generatedChartData(e);
        CategoryDataset categoryDataset = (CategoryDataset)chartData.getDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart((String)chartData.getPropertyChartTitle(), (String)"", (String)"Account Balance", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)this.backGroundPaintColor);
        CategoryPlot plot = chart.getCategoryPlot();
        List<Color> colorList = chartData.getPropertyColorListStackedBar();
        plot.getRenderer().setSeriesPaint(0, (Paint)colorList.get(0));
        plot.getRenderer().setSeriesPaint(1, (Paint)colorList.get(1));
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setRange(0.0, 100000.0);
        return plot;
    }
}

