/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.finmath.smartcontract.demo.plotgeneration.PlotGenerator;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.ApplicationFrame;

public class Visualiser
extends ApplicationFrame
implements ActionListener {
    private JPanel content;
    private ChartPanel chartPanel;
    private final List<PlotGenerator> chartGeneratorList;
    private final int horizontalLength = 800;
    private final int verticalLenght = 500;
    private final Timer timer = new Timer(200, this);

    public Visualiser(String title, List<PlotGenerator> chartGeneratorList) {
        super(title);
        this.chartGeneratorList = chartGeneratorList;
        this.generatePlot(null);
        this.timer.start();
    }

    private void generatePlot(ActionEvent event) {
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot();
        JFreeChart chart = new JFreeChart(this.getTitle(), new Font("Arial", 1, 12), (Plot)plot, false);
        chart.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        this.content = new JPanel(new FlowLayout());
        this.chartPanel = new ChartPanel(chart);
        this.chartGeneratorList.stream().map(generator -> generator.createPlot(event)).forEach(subplot -> {
            ChartPanel chartPanel2 = new ChartPanel(new JFreeChart(this.getTitle(), new Font("Arial", 1, 12), (Plot)subplot, false));
            chartPanel2.setPreferredSize(new Dimension(800, 500));
            chartPanel2.repaint();
            this.content.add((Component)chartPanel2);
        });
        this.setContentPane(this.content);
        this.content.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.generatePlot(event);
    }
}

