/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import javax.swing.Timer;
import net.finmath.smartcontract.contract.SmartDerivativeContractSchedule;

public class DemoScheduleSimulator
implements ActionListener {
    private final SmartDerivativeContractSchedule schedule;
    private final Timer timer = new Timer(1000, this);
    private final LocalDateTime initTime;
    private int eventTimeIndex;

    public DemoScheduleSimulator(SmartDerivativeContractSchedule schedule) {
        this.schedule = schedule;
        this.initTime = LocalDateTime.now();
        this.timer.start();
        this.eventTimeIndex = 0;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        SmartDerivativeContractSchedule.EventTimes actualEventTime = this.schedule.getEventTimes().get(this.eventTimeIndex);
        LocalDateTime eventTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(event.getWhen()), ZoneId.systemDefault());
        int index = (int)this.initTime.until(eventTime, ChronoUnit.SECONDS);
        int eventIndex = index % 3;
        if (eventIndex == 0) {
            System.out.println(index + " - " + actualEventTime.getMarginCheckTime());
        } else if (eventIndex == 1) {
            System.out.println(index + " - " + actualEventTime.getSettementTime());
        } else if (eventIndex == 2) {
            System.out.println(index + " - " + actualEventTime.getAccountAccessAllowedStart().plus(actualEventTime.getAccountAccessAllowedPeriod()));
            ++this.eventTimeIndex;
        }
    }
}

