/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo;

import java.awt.Window;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.finmath.marketdata.products.Swap;
import net.finmath.smartcontract.demo.Visualiser;
import net.finmath.smartcontract.demo.chartdatageneration.ChartDataGeneratorMarketValue;
import net.finmath.smartcontract.demo.chartdatageneration.ChartDataGeneratorSDCAccountBalance;
import net.finmath.smartcontract.demo.plotgeneration.PlotGenerator;
import net.finmath.smartcontract.demo.plotgeneration.StackedBarchartGenerator;
import net.finmath.smartcontract.demo.plotgeneration.TimeSeriesChartGenerator;
import net.finmath.smartcontract.oracle.ValuationOraclePlainSwapHistoricScenarios;
import net.finmath.smartcontract.simulation.products.IRSwapGenerator;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataScenario;
import net.finmath.smartcontract.simulation.scenariogeneration.IRScenarioGenerator;
import org.jfree.ui.RefineryUtilities;

public class DemoLauncher {
    public static void main(String[] args) throws Exception {
        LocalDate startDate = LocalDate.of(2007, 1, 1);
        LocalDate maturity = LocalDate.of(2012, 1, 3);
        String fileName = "timeseriesdatamap.json";
        DateTimeFormatter providedDateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
        List<IRMarketDataScenario> scenarioList = IRScenarioGenerator.getScenariosFromJsonFile("timeseriesdatamap.json", providedDateFormat).stream().filter(S -> S.getDate().toLocalDate().isAfter(startDate)).filter(S -> S.getDate().toLocalDate().isBefore(maturity)).collect(Collectors.toList());
        double notional = 1.0E7;
        String maturityKey = "5Y";
        String forwardCurveKey = "forward-EUR-6M";
        String discountCurveKey = "discount-EUR-OIS";
        LocalDate productStartDate = ((IRMarketDataScenario)scenarioList.get(0)).getDate().toLocalDate();
        double fixRate = ((IRMarketDataScenario)scenarioList.get(0)).getCurveData("Euribor6M").getDataPointStreamForProductType("Swap-Rate").filter(e -> e.getMaturity().equals("5Y")).mapToDouble(e -> e.getQuote()).findAny().getAsDouble() / 100.0;
        Swap swap = IRSwapGenerator.generateAnalyticSwapObject(productStartDate, "5Y", fixRate, true, "forward-EUR-6M", "discount-EUR-OIS");
        ValuationOraclePlainSwapHistoricScenarios oracle = new ValuationOraclePlainSwapHistoricScenarios(swap, 1.0E7, scenarioList);
        List<LocalDateTime> scenarioDates = scenarioList.stream().map(scenario -> scenario.getDate()).collect(Collectors.toList());
        ChartDataGeneratorSDCAccountBalance chartDataGeneratorSDCAccountBalance = new ChartDataGeneratorSDCAccountBalance(30000.0, oracle, scenarioDates);
        ChartDataGeneratorMarketValue marketValues = new ChartDataGeneratorMarketValue(oracle, scenarioDates);
        StackedBarchartGenerator barchartGenerator = new StackedBarchartGenerator(chartDataGeneratorSDCAccountBalance);
        TimeSeriesChartGenerator timeSeriesChartGenerator = new TimeSeriesChartGenerator(marketValues);
        ArrayList<PlotGenerator> generatorList = new ArrayList<PlotGenerator>();
        generatorList.add(timeSeriesChartGenerator);
        generatorList.add(barchartGenerator);
        Visualiser visualiser = new Visualiser("Smart Contract Simulation", generatorList);
        visualiser.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)visualiser));
        visualiser.setVisible(true);
    }
}

