/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.scenariogeneration;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.stream.Stream;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParser;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.simulation.scenariogeneration.IRCurveData;

public class IRMarketDataScenario {
    LocalDateTime scenarioDate;
    Map<String, IRCurveData> curveDataMap;
    final String productKey = "Swap-Rate";

    public IRMarketDataScenario(Map<String, IRCurveData> curveDataMap, LocalDateTime scenarioDate) {
        this.scenarioDate = scenarioDate;
        this.curveDataMap = curveDataMap;
    }

    public IRCurveData getCurveData(String curveKey) {
        return this.curveDataMap.get(curveKey);
    }

    public Stream<CalibrationSpecProvider> getDataAsCalibrationDataProintStream(CalibrationParser parser) {
        Stream<CalibrationDatapoint> calibrationDatapointStream = this.curveDataMap.entrySet().stream().flatMap(curveDataEntry -> {
            Stream<CalibrationDatapoint> calibrationDatapointSet = ((IRCurveData)curveDataEntry.getValue()).getDataPointStreamForProductType("Swap-Rate");
            return calibrationDatapointSet;
        });
        return parser.parse(calibrationDatapointStream);
    }

    public LocalDateTime getDate() {
        return this.scenarioDate;
    }
}

