/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.scenariogeneration;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationDatapoint;

public class IRCurveData {
    public Set<CalibrationDatapoint> curveDataPointSet;
    private String curveKey;

    public IRCurveData(String curveKey, Map<String, Map<String, Double>> typeCurveMap) {
        this.curveKey = curveKey;
        this.curveDataPointSet = typeCurveMap.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(curvePointEntry -> new CalibrationDatapoint(curveKey, (String)entry.getKey(), (String)curvePointEntry.getKey(), (Double)curvePointEntry.getValue()))).collect(Collectors.toSet());
    }

    public Stream<CalibrationDatapoint> getDataPointStreamForProductType(String productType) {
        return this.curveDataPointSet.stream().filter(dataPoint -> dataPoint.getProductName().equals(productType));
    }
}

