/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.products;

import java.time.LocalDate;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class IRSwapGenerator {
    public static final Swap generateAnalyticSwapObject(LocalDate startDate, String maturityLabel, double fixRate, boolean isReceiveFix, String forwardCurveName, String discountCurveName) {
        String frequencyLabel = forwardCurveName.contains("3M") ? "quarterly" : (forwardCurveName.contains("6M") ? "semiannual" : (forwardCurveName.contains("1M") ? "monthly" : "annual"));
        ScheduleInterface scheduleFloat = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)frequencyLabel, (String)"act/360", (String)"first", (String)"following", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        ScheduleInterface scheduleFix = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)"annual", (String)"E30/360", (String)"first", (String)"following", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        SwapLeg floatLeg = new SwapLeg(scheduleFloat, forwardCurveName, 0.0, discountCurveName);
        SwapLeg fixLeg = new SwapLeg(scheduleFix, "", fixRate, discountCurveName);
        Swap swap = isReceiveFix ? new Swap((AnalyticProductInterface)fixLeg, (AnalyticProductInterface)floatLeg) : new Swap((AnalyticProductInterface)floatLeg, (AnalyticProductInterface)fixLeg);
        return swap;
    }
}

