/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.time.LocalDate;
import java.util.Optional;
import java.util.stream.Stream;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.optimizer.SolverException;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class Calibrator {
    public static final String DISCOUNT_EUR_OIS = "discount-EUR-OIS";

    public Optional<CalibrationResult> calibrateModel(Stream<CalibrationSpecProvider> providers, CalibrationContext ctx) throws CloneNotSupportedException {
        AnalyticModel model = new AnalyticModel(this.getCalibrationCurves(ctx));
        CalibratedCurves.CalibrationSpec[] specs = (CalibratedCurves.CalibrationSpec[])providers.map(c -> c.getCalibrationSpec(ctx)).toArray(CalibratedCurves.CalibrationSpec[]::new);
        try {
            return Optional.of(new CalibrationResult(new CalibratedCurves(specs, model, ctx.getAccuracy()), specs));
        }
        catch (SolverException e) {
            return Optional.empty();
        }
    }

    private CurveInterface[] getCalibrationCurves(CalibrationContext ctx) {
        return new CurveInterface[]{this.getOisDiscountCurve(ctx), this.getOisForwardCurve(ctx), this.get1MForwardCurve(ctx), this.get3MForwardCurve(ctx), this.get6MForwardCurve(ctx)};
    }

    private DiscountCurve getOisDiscountCurve(CalibrationContext ctx) {
        return DiscountCurve.createDiscountCurveFromDiscountFactors((String)DISCOUNT_EUR_OIS, (LocalDate)ctx.getReferenceDate(), (double[])new double[]{0.0}, (double[])new double[]{1.0}, (boolean[])new boolean[]{false}, (Curve.InterpolationMethod)Curve.InterpolationMethod.LINEAR, (Curve.ExtrapolationMethod)Curve.ExtrapolationMethod.CONSTANT, (Curve.InterpolationEntity)Curve.InterpolationEntity.LOG_OF_VALUE);
    }

    private ForwardCurveInterface getOisForwardCurve(CalibrationContext ctx) {
        return new ForwardCurveFromDiscountCurve("forward-EUR-OIS", DISCOUNT_EUR_OIS, ctx.getReferenceDate(), "3M");
    }

    private ForwardCurveInterface get3MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurve("forward-EUR-3M", ctx.getReferenceDate(), "3M", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, ForwardCurve.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }

    private ForwardCurveInterface get6MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurve("forward-EUR-6M", ctx.getReferenceDate(), "6M", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, ForwardCurve.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }

    private ForwardCurveInterface get1MForwardCurve(CalibrationContext ctx) {
        return new ForwardCurve("forward-EUR-1M", ctx.getReferenceDate(), "1M", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), BusinessdayCalendarInterface.DateRollConvention.FOLLOWING, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, ForwardCurve.InterpolationEntityForward.FORWARD, DISCOUNT_EUR_OIS);
    }
}

