/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.time.LocalDate;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public class CalibrationSpecProviderOis
implements CalibrationSpecProvider {
    private String maturityLabel;
    private String frequency;
    private double swapRate;

    public CalibrationSpecProviderOis(String maturityLabel, String frequency, double swapRate) {
        this.maturityLabel = maturityLabel;
        this.frequency = frequency;
        this.swapRate = swapRate;
    }

    @Override
    public CalibratedCurves.CalibrationSpec getCalibrationSpec(CalibrationContext ctx) {
        ScheduleInterface scheduleInterfaceRec = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)"0D", (String)this.maturityLabel, (String)this.frequency, (String)"act/360", (String)"first", (String)"modified_following", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)1);
        ScheduleInterface scheduleInterfacePay = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)"0D", (String)this.maturityLabel, (String)this.frequency, (String)"act/360", (String)"first", (String)"modified_following", (BusinessdayCalendarInterface)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)1);
        double calibrationTime = scheduleInterfaceRec.getPayment(scheduleInterfaceRec.getNumberOfPeriods() - 1);
        return new CalibratedCurves.CalibrationSpec(String.format("EUR-OIS-%1$s", this.maturityLabel), "Swap", scheduleInterfaceRec, "forward-EUR-OIS", 0.0, "discount-EUR-OIS", scheduleInterfacePay, "", this.swapRate, "discount-EUR-OIS", "discount-EUR-OIS", calibrationTime);
    }
}

