/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.simulation.curvecalibration;

import java.time.LocalTime;
import java.util.Arrays;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.marketdata.model.AnalyticModelInterface;

public class CalibrationResult {
    private LocalTime freshness;
    private CalibratedCurves calibration;
    private CalibratedCurves.CalibrationSpec[] calibrationSpecs;

    public CalibrationResult(CalibratedCurves c, CalibratedCurves.CalibrationSpec ... specs) {
        this.calibration = c;
        this.calibrationSpecs = specs;
        this.freshness = LocalTime.now();
    }

    public AnalyticModelInterface getCalibratedModel() {
        return this.calibration.getModel();
    }

    public double getSumOfSquaredErrors() {
        return Arrays.stream(this.calibrationSpecs).mapToDouble(s -> Math.pow(this.calibration.getCalibrationProductForSpec(s).getValue(0.0, this.getCalibratedModel()), 2.0)).sum();
    }

    public LocalTime getFreshness() {
        return this.freshness;
    }
}

