/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.smartcontract.oracle.ValuationOracle;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationParserDataPoints;
import net.finmath.smartcontract.simulation.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.simulation.curvecalibration.Calibrator;
import net.finmath.smartcontract.simulation.scenariogeneration.IRMarketDataScenario;
import net.finmath.time.FloatingpointDate;

public class ValuationOraclePlainSwapHistoricScenarios
implements ValuationOracle {
    List<IRMarketDataScenario> scenarioList;
    Swap product;
    LocalDate productStartDate;
    double notionalAmount;

    public ValuationOraclePlainSwapHistoricScenarios(Swap product, double notionalAmount, List<IRMarketDataScenario> scenarioList) {
        this.notionalAmount = notionalAmount;
        this.product = product;
        this.productStartDate = ((SwapLeg)this.product.getLegPayer()).getSchedule().getReferenceDate();
        this.scenarioList = scenarioList;
    }

    private double getEvaluationTimeFromScenarioDate(LocalDateTime scenarioDate) {
        return FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)LocalDateTime.of(this.productStartDate, LocalTime.of(0, 0)), (LocalDateTime)scenarioDate);
    }

    @Override
    public Double getValue(LocalDateTime evaluationTime) {
        Optional<IRMarketDataScenario> optionalScenario = this.scenarioList.stream().filter(scenario -> scenario.getDate().equals(evaluationTime)).findAny();
        if (optionalScenario.isPresent()) {
            IRMarketDataScenario scenario2 = optionalScenario.get();
            CalibrationParserDataPoints parser = new CalibrationParserDataPoints();
            Calibrator calibrator = new Calibrator();
            try {
                Optional<CalibrationResult> optionalCalibrationResult = calibrator.calibrateModel(scenario2.getDataAsCalibrationDataProintStream(parser), new CalibrationContextImpl(LocalDate.now(), 1.0E-6));
                AnalyticModelInterface calibratedModel = optionalCalibrationResult.get().getCalibratedModel();
                double valueWithCurves = this.product.getValue(this.getEvaluationTimeFromScenarioDate(evaluationTime), calibratedModel) * this.notionalAmount;
                calibratedModel = null;
                return valueWithCurves;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

