/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle;

import java.time.LocalDateTime;
import net.finmath.smartcontract.oracle.StochasticValuationOracle;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.stochastic.Scalar;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class ContinouslyCompoundedBankAccountOracle
implements StochasticValuationOracle {
    private final TimeDiscretizationInterface timeDiscretization;
    private final LocalDateTime initialTime;
    private final double initialValue;
    private final double riskFreeRate;

    public ContinouslyCompoundedBankAccountOracle() {
        this(LocalDateTime.now());
    }

    public ContinouslyCompoundedBankAccountOracle(LocalDateTime initialTime) {
        this((TimeDiscretizationInterface)new TimeDiscretization(0.0, 20.0, 0.0027397260273972603, TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, 1.0, 0.02);
    }

    public ContinouslyCompoundedBankAccountOracle(LocalDateTime initialTime, double initialValue, double timeHorizon, double riskFreeRate) {
        this((TimeDiscretizationInterface)new TimeDiscretization(0.0, timeHorizon, 0.0027397260273972603, TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, initialValue, riskFreeRate);
    }

    public ContinouslyCompoundedBankAccountOracle(TimeDiscretizationInterface timeDiscretization, LocalDateTime initialTime, double initialValue, double riskFreeRate) {
        this.timeDiscretization = timeDiscretization;
        this.initialTime = initialTime;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
    }

    @Override
    public RandomVariableInterface getValue(LocalDateTime evaluationTime) {
        double time = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.initialTime, (LocalDateTime)evaluationTime);
        return new Scalar(this.initialValue * Math.exp(this.riskFreeRate * time));
    }
}

