/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.oracle;

import java.time.LocalDateTime;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.IndependentIncrementsInterface;
import net.finmath.montecarlo.assetderivativevaluation.BachelierModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.montecarlo.process.ProcessEulerScheme;
import net.finmath.smartcontract.oracle.StochasticValuationOracle;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianMotionOracle
implements StochasticValuationOracle {
    private final TimeDiscretizationInterface timeDiscretization;
    private final LocalDateTime initialTime;
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final int numberOfPaths;
    private transient MonteCarloAssetModel simulation;
    private final Object simulationLazyInitLock = new Object();

    public BrownianMotionOracle() {
        this(LocalDateTime.now());
    }

    public BrownianMotionOracle(LocalDateTime initialTime) {
        this(initialTime, 0.0, 20.0, 0.02, 0.1, 1000);
    }

    public BrownianMotionOracle(LocalDateTime initialTime, double initialValue, double timeHorizon, double riskFreeRate, double volatility, int numberOfPaths) {
        this((TimeDiscretizationInterface)new TimeDiscretization(0.0, timeHorizon, 0.0027397260273972603, TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, initialValue, riskFreeRate, volatility, numberOfPaths);
    }

    public BrownianMotionOracle(TimeDiscretizationInterface timeDiscretization, LocalDateTime initialTime, double initialValue, double riskFreeRate, double volatility, int numberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.initialTime = initialTime;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.numberOfPaths = numberOfPaths;
    }

    private void init() {
        boolean numberOfFactors = true;
        int seed = 31415;
        this.simulation = new MonteCarloAssetModel((AbstractModelInterface)new BachelierModel(this.initialValue, this.riskFreeRate, this.volatility), (AbstractProcessInterface)new ProcessEulerScheme((IndependentIncrementsInterface)new BrownianMotion(this.timeDiscretization, 1, this.numberOfPaths, 31415)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getValue(LocalDateTime evaluationTime) {
        Object object = this.simulationLazyInitLock;
        synchronized (object) {
            if (this.simulation == null) {
                this.init();
            }
        }
        double time = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.initialTime, (LocalDateTime)evaluationTime);
        int timeIndexOfLastFixing = this.timeDiscretization.getTimeIndexNearestLessOrEqual(time);
        double timeOfLastFixing = this.timeDiscretization.getTime(timeIndexOfLastFixing);
        RandomVariableInterface value = null;
        try {
            value = this.simulation.getAssetValue(timeOfLastFixing, 0);
        }
        catch (CalculationException e) {
            Logger.getLogger("net.finmath.smartcontract").warning("Oracle valuation failed with " + e.getCause());
        }
        return value;
    }
}

