/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.contract;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import net.finmath.smartcontract.contract.SmartDerivativeContractSchedule;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class SmartDerivativeContractScheduleGenerator {
    public static SmartDerivativeContractSchedule getScheduleForBusinessDays(String calendar, LocalDate startDate, LocalDate maturity, LocalTime settlementTime, Duration accountAccessAllowedDuration) {
        return SmartDerivativeContractScheduleGenerator.getScheduleForBusinessDays(calendar, startDate, maturity, settlementTime, settlementTime.plusMinutes(1L), accountAccessAllowedDuration, settlementTime.plusMinutes(1L).plusSeconds(accountAccessAllowedDuration.getSeconds()).plusMinutes(1L));
    }

    public static SmartDerivativeContractSchedule getScheduleForBusinessDays(String calendar, LocalDate startDate, LocalDate maturity, LocalTime settlementTime, LocalTime accountAccessAllowedStartTime, Duration accountAccessAllowedDuration, LocalTime marginCheckTime) {
        BusinessdayCalendarExcludingTARGETHolidays bdCalendar = new BusinessdayCalendarExcludingTARGETHolidays();
        ArrayList<SmartDerivativeContractSchedule.EventTimes> eventTimesList = new ArrayList<SmartDerivativeContractSchedule.EventTimes>();
        LocalDate settlementDate = startDate;
        while (!settlementDate.isAfter(maturity)) {
            EventTimesImpl event = new EventTimesImpl(settlementDate.atTime(settlementTime), settlementDate.atTime(accountAccessAllowedStartTime), accountAccessAllowedDuration, settlementDate.atTime(marginCheckTime));
            eventTimesList.add(event);
            settlementDate = bdCalendar.getRolledDate(settlementDate, 1);
        }
        return new SimpleSchedule(eventTimesList);
    }

    public static class SimpleSchedule
    implements SmartDerivativeContractSchedule {
        private final List<SmartDerivativeContractSchedule.EventTimes> eventTimes;

        public SimpleSchedule(List<SmartDerivativeContractSchedule.EventTimes> eventTimes) {
            this.eventTimes = eventTimes;
        }

        @Override
        public List<SmartDerivativeContractSchedule.EventTimes> getEventTimes() {
            return this.eventTimes;
        }
    }

    public static class EventTimesImpl
    implements SmartDerivativeContractSchedule.EventTimes {
        private final LocalDateTime settementTime;
        private final LocalDateTime accountAccessAllowedStart;
        private final Duration accountAccessAllowedPeriod;
        private final LocalDateTime marginCheckTime;

        public EventTimesImpl(LocalDateTime settementTime, LocalDateTime accountAccessAllowedStart, Duration accountAccessAllowedPeriod, LocalDateTime marginCheckTime) {
            this.settementTime = settementTime;
            this.accountAccessAllowedStart = accountAccessAllowedStart;
            this.accountAccessAllowedPeriod = accountAccessAllowedPeriod;
            this.marginCheckTime = marginCheckTime;
        }

        @Override
        public LocalDateTime getSettementTime() {
            return this.settementTime;
        }

        @Override
        public LocalDateTime getAccountAccessAllowedStart() {
            return this.accountAccessAllowedStart;
        }

        @Override
        public Duration getAccountAccessAllowedPeriod() {
            return this.accountAccessAllowedPeriod;
        }

        @Override
        public LocalDateTime getMarginCheckTime() {
            return this.marginCheckTime;
        }
    }
}

