/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.contract;

import java.time.LocalDateTime;
import java.util.NoSuchElementException;
import net.finmath.smartcontract.oracle.ValuationOracle;

public class SmartDerivativeContractMargining {
    private final ValuationOracle derivativeValuationOracle;
    private final ValuationOracle collateralValuationOracle;

    public SmartDerivativeContractMargining(ValuationOracle derivativeValuationOracle, ValuationOracle collateralValuationOracle) {
        this.derivativeValuationOracle = derivativeValuationOracle;
        this.collateralValuationOracle = collateralValuationOracle;
    }

    public Double getMargin(LocalDateTime marginPeriodStart, LocalDateTime marginPeriodEnd) {
        try {
            double valueDerivativeCurrent = this.derivativeValuationOracle.getValue(marginPeriodEnd);
            double valueDerivativePrevious = this.derivativeValuationOracle.getValue(marginPeriodStart);
            double valueCollateralCurrent = this.collateralValuationOracle.getValue(marginPeriodEnd);
            double valueCollateralPrevious = this.collateralValuationOracle.getValue(marginPeriodStart);
            double valuationChange = valueDerivativeCurrent - valueDerivativePrevious;
            double collateralChange = valueDerivativePrevious * (valueCollateralCurrent / valueCollateralPrevious - 1.0);
            double margin = valuationChange - collateralChange;
            return margin;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

