/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleUnaryOperator;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plot2D;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableFunction2D;
import net.finmath.plots.PlotablePoints2D;
import net.finmath.plots.Point2D;

public class Plot2DDemo8 {
    public static void main(String[] args) throws Exception {
        Random random = new Random(3141L);
        int numberOfSamplePoints = 100;
        ArrayList<Point2D> series1 = new ArrayList<Point2D>();
        ArrayList<Point2D> series2 = new ArrayList<Point2D>();
        for (int i = 0; i < 100; ++i) {
            double x2 = 2.0 * random.nextDouble() - 1.0;
            double y = x2 * x2;
            double e1 = 1.0 * random.nextDouble() - 0.5;
            double e2 = 2.0 * random.nextDouble() - 1.0;
            series1.add(new Point2D(x2, y + e1));
            series2.add(new Point2D(x2, y + e2));
        }
        List<Plotable2D> plotables = List.of(new PlotableFunction2D(-1.0, 1.0, 1000, new Named<DoubleUnaryOperator>("True Function", x -> x * x), new GraphStyle(new Rectangle(2, 2), null, Color.GREEN)), new PlotablePoints2D("Values 1", series1, new GraphStyle(new Rectangle(3, 3), null, Color.BLUE)), new PlotablePoints2D("Values 2", series2, new GraphStyle(new Rectangle(3, 3), null, Color.RED)));
        Plot2D plot = new Plot2D(plotables);
        plot.setTitle("Two Scatters and a Function").setXAxisLabel("x").setYAxisLabel("y").setIsLegendVisible(true).show();
    }
}

