/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.DoubleFunction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.finmath.plots.DoubleToRandomVariableFunction;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import net.finmath.plots.jfreechart.JFreeChartUtilities;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PlotProcess2D
implements Plot {
    private final TimeDiscretization timeDiscretization;
    private final Named<DoubleFunction<RandomVariable>> process;
    private final int maxNumberOfPaths;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat = new DecimalFormat("#.##");
    private NumberFormat yAxisNumberFormat = new DecimalFormat("#.##");
    private Boolean isLegendVisible = false;
    private transient JFrame frame;
    private transient JFreeChart chart;

    public PlotProcess2D(TimeDiscretization timeDiscretization, Named<DoubleFunction<RandomVariable>> process, int maxNumberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.process = process;
        this.maxNumberOfPaths = maxNumberOfPaths;
    }

    public PlotProcess2D(TimeDiscretization timeDiscretization, DoubleFunction<RandomVariable> process, int maxNumberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.process = new Named<DoubleFunction<RandomVariable>>("", process);
        this.maxNumberOfPaths = maxNumberOfPaths;
    }

    public PlotProcess2D(TimeDiscretization timeDiscretization, DoubleToRandomVariableFunction process, int maxNumberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.process = new Named<DoubleFunction<RandomVariable>>("", t -> {
            try {
                return process.apply(t);
            }
            catch (Exception e) {
                return null;
            }
        });
        this.maxNumberOfPaths = maxNumberOfPaths;
    }

    public PlotProcess2D(TimeDiscretization timeDiscretization, Named<DoubleFunction<RandomVariable>> process) {
        this(timeDiscretization, process, 100);
    }

    private void init() {
        ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            RandomVariable randomVariable = this.process.get().apply(time);
            for (int pathIndex = 0; pathIndex < Math.min(randomVariable.size(), this.maxNumberOfPaths); ++pathIndex) {
                XYSeries series;
                XYSeries xYSeries = series = pathIndex < seriesList.size() ? (XYSeries)seriesList.get(pathIndex) : null;
                if (series == null) {
                    series = new XYSeries((Comparable)Integer.valueOf(pathIndex));
                    seriesList.add(pathIndex, series);
                }
                series.add(time, randomVariable.get(pathIndex));
            }
        }
        XYSeriesCollection data = new XYSeriesCollection();
        for (XYSeries series : seriesList) {
            data.addSeries(series);
        }
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(2);
        renderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        renderer.setSeriesPaint(1, (Paint)new Color(0, 255, 0));
        renderer.setSeriesPaint(2, (Paint)new Color(0, 0, 255));
        this.chart = JFreeChartUtilities.getXYPlotChart(this.title, this.xAxisLabel, "#.#", this.yAxisLabel, "#.#", data, (AbstractXYItemRenderer)renderer, this.isLegendVisible);
        if (this.xAxisNumberFormat != null) {
            ((NumberAxis)this.chart.getXYPlot().getDomainAxis()).setNumberFormatOverride(this.xAxisNumberFormat);
        }
        if (this.yAxisNumberFormat != null) {
            ((NumberAxis)this.chart.getXYPlot().getRangeAxis()).setNumberFormatOverride(this.yAxisNumberFormat);
        }
    }

    @Override
    public void show() {
        this.init();
        ChartPanel chartPanel = new ChartPanel(this.chart, 800, 400, 128, 128, 2024, 2024, false, true, true, false, true, false);
        EventQueue.invokeLater(new Runnable((JPanel)chartPanel){
            final /* synthetic */ JPanel val$chartPanel;
            {
                this.val$chartPanel = jPanel;
            }

            @Override
            public void run() {
                if (PlotProcess2D.this.frame != null) {
                    PlotProcess2D.this.frame.dispose();
                }
                PlotProcess2D.this.frame = new JFrame();
                PlotProcess2D.this.frame.add(this.val$chartPanel);
                PlotProcess2D.this.frame.setVisible(true);
                PlotProcess2D.this.frame.pack();
            }
        });
    }

    @Override
    public void close() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
        JFreeChartUtilities.saveChartAsJPG(file, this.chart, width, height);
    }

    public void saveAsPNG(File file, int width, int height) throws IOException {
        JFreeChartUtilities.saveChartAsPNG(file, this.chart, width, height);
    }

    @Override
    public void saveAsPDF(File file, int width, int height) throws IOException {
        JFreeChartUtilities.saveChartAsPDF(file, this.chart, width, height);
    }

    @Override
    public void saveAsSVG(File file, int width, int height) throws IOException {
        JFreeChartUtilities.saveChartAsSVG(file, this.chart, width, height);
    }

    @Override
    public PlotProcess2D setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public PlotProcess2D setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public PlotProcess2D setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    public PlotProcess2D setXAxisNumberFormat(NumberFormat xAxisNumberFormat) {
        this.xAxisNumberFormat = xAxisNumberFormat;
        return this;
    }

    public PlotProcess2D setYAxisNumberFormat(NumberFormat yAxisNumberFormat) {
        this.yAxisNumberFormat = yAxisNumberFormat;
        return this;
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }

    public String toString() {
        return "PlotProcess2D [timeDiscretization=" + this.timeDiscretization + ", process=" + this.process + ", maxNumberOfPaths=" + this.maxNumberOfPaths + ", title=" + this.title + ", xAxisLabel=" + this.xAxisLabel + ", yAxisLabel=" + this.yAxisLabel + ", xAxisNumberFormat=" + this.xAxisNumberFormat + ", yAxisNumberFormat=" + this.yAxisNumberFormat + ", isLegendVisible=" + this.isLegendVisible + "]";
    }
}

