/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.PaintScale;

public class AlphaGrayScale
implements PaintScale {
    private double lowerBound;
    private double upperBound;
    private double frequency;
    private double thickness;

    public AlphaGrayScale(double lowerBound, double upperBound, double frequency, double thickness) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.frequency = frequency;
        this.thickness = thickness;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public Paint getPaint(double value) {
        float level = (float)Math.sin(1.5707963267948966 * (1.0 - this.thickness));
        if (Double.isNaN(value)) {
            return Color.GRAY;
        }
        double percentageValue = Math.min(Math.max((value - this.lowerBound) / (this.upperBound - this.lowerBound), 0.0), 1.0);
        return new Color(0.0f, 0.0f, 0.0f, (float)Math.max(Math.sin(62.83185307179586 * percentageValue) - (double)level, 0.0) / (1.0f - level));
    }
}

