/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.finmath.plots.jfreechart.HuePaintScale;
import net.finmath.plots.jfreechart.StyleGuide;
import org.apache.commons.math3.linear.RealMatrix;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;

public class JFreeChartUtilities {
    public static JFreeChart getContourPlot(String labelX, String labelY, String labelZ, RealMatrix dataMatrix) {
        int numberOfValues = dataMatrix.getColumnDimension() * dataMatrix.getRowDimension();
        double[] xValues = new double[numberOfValues];
        double[] yValues = new double[numberOfValues];
        double[] zValues = new double[numberOfValues];
        int valueIndex = 0;
        for (int col = 0; col < dataMatrix.getColumnDimension(); ++col) {
            for (int row = 0; row < dataMatrix.getRowDimension(); ++row) {
                xValues[valueIndex] = col;
                yValues[valueIndex] = row;
                zValues[valueIndex] = dataMatrix.getEntry(row, col);
                ++valueIndex;
            }
        }
        DefaultXYZDataset dataset = new DefaultXYZDataset();
        dataset.addSeries((Comparable)((Object)"Correlation"), (double[][])new double[][]{xValues, yValues, zValues});
        return JFreeChartUtilities.getContourPlot(dataset, new XYBlockRenderer(), new HuePaintScale(-1.0, 1.0), new NumberAxis(labelX), new NumberAxis(labelY), new NumberAxis(labelZ), dataMatrix.getColumnDimension(), dataMatrix.getRowDimension());
    }

    public static JFreeChart getContourPlot(DefaultXYZDataset dataset, XYBlockRenderer renderer, HuePaintScale paintScale, NumberAxis xAxis, NumberAxis yAxis, NumberAxis zAxis, int xItems, int yItems) {
        StyleGuide style = new StyleGuide(1.0);
        xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" 0.00"));
        yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" 0.00"));
        xAxis.setLabelFont(style.getAxisLabelFont());
        yAxis.setLabelFont(style.getAxisLabelFont());
        xAxis.setTickLabelFont(style.getTickLabelFont());
        yAxis.setTickLabelFont(style.getTickLabelFont());
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        JFreeChart chart = new JFreeChart(null, style.getTitleFont(), (Plot)plot, false);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        zAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" 0.00"));
        renderer.setPaintScale((PaintScale)paintScale);
        PaintScaleLegend psl = new PaintScaleLegend(renderer.getPaintScale(), (ValueAxis)zAxis);
        psl.setAxisOffset(5.0);
        psl.setPosition(RectangleEdge.LEFT);
        psl.setMargin(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        chart.addSubtitle((Title)psl);
        JFreeChartUtilities.updateContourPlot(dataset, renderer, paintScale, xAxis, yAxis, zAxis, xItems, yItems);
        return chart;
    }

    public static void updateContourPlot(DefaultXYZDataset dataset, XYBlockRenderer renderer, HuePaintScale paintScale, NumberAxis xAxis, NumberAxis yAxis, NumberAxis zAxis, int xItems, int yItems) {
        StyleGuide style = new StyleGuide(1.0);
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (int i = 0; i < dataset.getItemCount(0); ++i) {
            minX = Math.min(dataset.getXValue(0, i), minX);
            maxX = Math.max(dataset.getXValue(0, i), maxX);
            minY = Math.min(dataset.getYValue(0, i), minY);
            maxY = Math.max(dataset.getYValue(0, i), maxY);
            if (Double.isNaN(dataset.getZ(0, i).doubleValue())) continue;
            minZ = Math.min(dataset.getZValue(0, i), minZ);
            maxZ = Math.max(dataset.getZValue(0, i), maxZ);
        }
        if (xAxis != null) {
            xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" 0.00"));
            xAxis.setLabelFont(style.getAxisLabelFont());
            xAxis.setTickLabelFont(style.getTickLabelFont());
            xAxis.setRange(minX, maxX);
        }
        if (yAxis != null) {
            yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(" 0.00"));
            yAxis.setLabelFont(style.getAxisLabelFont());
            yAxis.setTickLabelFont(style.getTickLabelFont());
            yAxis.setRange(minY, maxY);
        }
        if (zAxis != null) {
            zAxis.setRange(minZ, maxZ);
        }
        if (renderer != null) {
            renderer.setBlockWidth((maxX - minX) / (double)(xItems - 1));
            renderer.setBlockHeight((maxY - minY) / (double)(yItems - 1));
        }
        if (paintScale != null) {
            paintScale.lowerBound = minZ;
            paintScale.upperBound = maxZ;
        }
    }

    public static JFreeChart getXYLinesPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, double[] xValues, double[] yValues) {
        XYSeriesCollection data = new XYSeriesCollection();
        XYSeries series = new XYSeries((Comparable)((Object)"1"));
        for (int i = 0; i < xValues.length; ++i) {
            series.add(xValues[i], yValues[i]);
        }
        data.addSeries(series);
        return JFreeChartUtilities.getXYPlotChart(title, xAxisLabel, xAxisNumberFormat, yAxisLabel, yAxisNumberFormat, data);
    }

    public static JFreeChart getXYLinesPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, RealMatrix xyData) {
        XYSeriesCollection data = new XYSeriesCollection();
        for (int col = 1; col < xyData.getColumnDimension(); ++col) {
            XYSeries series = new XYSeries((Comparable)((Object)("" + col)));
            for (int row = 0; row < xyData.getRowDimension(); ++row) {
                series.add(xyData.getEntry(row, 0), xyData.getEntry(row, col));
            }
            data.addSeries(series);
        }
        return JFreeChartUtilities.getXYPlotChart(title, xAxisLabel, xAxisNumberFormat, yAxisLabel, yAxisNumberFormat, data);
    }

    public static JFreeChart getCategoryLinesPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, RealMatrix xyData) {
        XYSeriesCollection data = new XYSeriesCollection();
        for (int col = 0; col < xyData.getColumnDimension(); ++col) {
            XYSeries series = new XYSeries((Comparable)((Object)("" + col)));
            for (int row = 0; row < xyData.getRowDimension(); ++row) {
                series.add((double)row, xyData.getEntry(row, col));
            }
            data.addSeries(series);
        }
        return JFreeChartUtilities.getXYPlotChart(title, xAxisLabel, xAxisNumberFormat, yAxisLabel, yAxisNumberFormat, data);
    }

    public static JFreeChart getXYPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, XYSeriesCollection data) {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(2);
        renderer.setSeriesPaint(0, (Paint)new Color(255, 0, 0));
        renderer.setSeriesPaint(1, (Paint)new Color(0, 255, 0));
        renderer.setSeriesPaint(2, (Paint)new Color(0, 0, 255));
        return JFreeChartUtilities.getXYPlotChart(title, xAxisLabel, xAxisNumberFormat, yAxisLabel, yAxisNumberFormat, data, (AbstractXYItemRenderer)renderer);
    }

    public static JFreeChart getXYPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, XYSeriesCollection data, AbstractXYItemRenderer renderer) {
        return JFreeChartUtilities.getXYPlotChart(title, xAxisLabel, xAxisNumberFormat, yAxisLabel, yAxisNumberFormat, data, renderer, false);
    }

    public static JFreeChart getXYPlotChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, XYSeriesCollection data, AbstractXYItemRenderer renderer, boolean legend) {
        StyleGuide style = new StyleGuide(2.0);
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(xAxisNumberFormat, new DecimalFormatSymbols(Locale.ENGLISH)));
        yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(yAxisNumberFormat, new DecimalFormatSymbols(Locale.ENGLISH)));
        xAxis.setLabelFont(style.getAxisLabelFont());
        yAxis.setLabelFont(style.getAxisLabelFont());
        xAxis.setTickLabelFont(style.getTickLabelFont());
        yAxis.setTickLabelFont(style.getTickLabelFont());
        xAxis.setAutoRangeIncludesZero(false);
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        style.applyStyleToXYPlot2(plot);
        JFreeChart chart = new JFreeChart(title, style.getTitleFont(), (Plot)plot, legend);
        style.applyStyleToChart2(chart);
        return chart;
    }

    public static JFreeChart getXYPlotLogChart(String title, String xAxisLabel, String xAxisNumberFormat, String yAxisLabel, String yAxisNumberFormat, XYSeriesCollection data, AbstractXYItemRenderer renderer, boolean legend) {
        StyleGuide style = new StyleGuide(2.0);
        LogarithmicAxis xAxis = new LogarithmicAxis(xAxisLabel);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        xAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(xAxisNumberFormat, new DecimalFormatSymbols(Locale.ENGLISH)));
        yAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat(yAxisNumberFormat, new DecimalFormatSymbols(Locale.ENGLISH)));
        xAxis.setLabelFont(style.getAxisLabelFont());
        yAxis.setLabelFont(style.getAxisLabelFont());
        xAxis.setTickLabelFont(style.getTickLabelFont());
        yAxis.setTickLabelFont(style.getTickLabelFont());
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        plot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        JFreeChart chart = new JFreeChart(title, style.getTitleFont(), (Plot)plot, legend);
        return chart;
    }

    public static void saveChartAsPDF(File file, JFreeChart chart, int width, int height) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        JFreeChartUtilities.writeChartAsPDF(out, chart, width, height);
        ((OutputStream)out).close();
    }

    public static void saveChartAsSVG(File file, JFreeChart chart, int width, int height) throws IOException {
        SVGGraphics2D g2 = new SVGGraphics2D(width, height);
        g2.setRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION, (Object)true);
        java.awt.Rectangle r = new java.awt.Rectangle(0, 0, 600, 400);
        chart.draw((Graphics2D)g2, (Rectangle2D)r);
        SVGUtils.writeToSVG((File)file, (String)g2.getSVGElement());
    }

    public static void saveChartAsJPG(File file, JFreeChart chart, int width, int height) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        BufferedImage imageWithAlpha = new BufferedImage(width, height, 2);
        Graphics2D g2 = imageWithAlpha.createGraphics();
        Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
        chart.draw(g2, (Rectangle2D)r2D);
        g2.dispose();
        BufferedImage imageWithoutAlpha = new BufferedImage(width, height, 1);
        Graphics2D graphics = imageWithoutAlpha.createGraphics();
        graphics.drawImage(imageWithAlpha, null, 0, 0);
        ImageIO.write((RenderedImage)imageWithoutAlpha, "jpg", out);
        ((OutputStream)out).close();
    }

    public static void writeChartAsPDF(OutputStream out, JFreeChart chart, int width, int height) {
        Rectangle pagesize = new Rectangle((float)width, (float)height);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.addAuthor("Christian Fries");
            document.addSubject("Chart");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)tp, (float)width, (float)height);
            Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
            chart.draw((Graphics2D)g2, (Rectangle2D)r2D);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }
}

