/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import net.finmath.plots.Named;
import net.finmath.plots.Plot2D;

public class Plot2DDemo4 {
    public static void main(String[] args) throws Exception {
        double x = 0.0;
        DoubleUnaryOperator functionDerivativeCentral = shiftScale -> {
            double shiftSize = Math.pow(10.0, -shiftScale);
            double valueUp = Math.exp(0.0 + shiftSize);
            double valueDown = Math.exp(0.0 - shiftSize);
            double derivativeFiniteDifference = (valueUp - valueDown) / 2.0 / shiftSize - 1.0;
            return derivativeFiniteDifference;
        };
        DoubleUnaryOperator functionDerivativeForward = shiftScale -> {
            double shiftSize = Math.pow(10.0, -shiftScale);
            double valueUp = Math.exp(0.0 + shiftSize);
            double value = Math.exp(0.0);
            double derivativeFiniteDifference = (valueUp - value) / shiftSize - 1.0;
            return derivativeFiniteDifference;
        };
        DoubleUnaryOperator functionDerivativeAnalytic = shiftScale -> Math.exp(0.0) - 1.0;
        Plot2D plotDerivativeForward = new Plot2D(5.0, 10.0, 100, Arrays.asList(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeForward), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeForward.setTitle("(One Sided Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("value").setIsLegendVisible(true);
        plotDerivativeForward.setyAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeForward.show();
        Plot2D plotDerivativeCentral1 = new Plot2D(4.5, 6.5, 100, Arrays.asList(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeCentral), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeCentral1.setTitle("(Central Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("value").setIsLegendVisible(true);
        plotDerivativeCentral1.setyAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeCentral1.setYRange(-5.0E-10, 5.0E-10);
        plotDerivativeCentral1.show();
        Plot2D plotDerivativeCentral2 = new Plot2D(1.0, 20.0, 100, Arrays.asList(new Named<DoubleUnaryOperator>("Finite Difference Approximation", functionDerivativeCentral), new Named<DoubleUnaryOperator>("Analytic", functionDerivativeAnalytic)));
        plotDerivativeCentral2.setTitle("(Central Finite Difference) Derivative of exp(x) at x = 0.0").setXAxisLabel("scale (h = 10^{-scale})").setYAxisLabel("value").setIsLegendVisible(true);
        plotDerivativeCentral1.setyAxisNumberFormat(new DecimalFormat("0.0E00"));
        plotDerivativeCentral2.show();
    }
}

