/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Plot;
import net.finmath.plots.Plot2D;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotablePoints2D;
import net.finmath.plots.Point2D;
import net.finmath.plots.axis.NumberAxis;
import net.finmath.stochastic.RandomVariable;

public class Plots {
    public static Plot createPlotOfHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations) {
        return Plots.createPlotOfHistogramBehindValues(randomVariableX, randomVariableY, numberOfPoints, standardDeviations, null, null);
    }

    public static Plot createPlotOfHistogramBehindValues(RandomVariable randomVariableX, RandomVariable randomVariableY, int numberOfPoints, double standardDeviations, Double xmin, Double xmax) {
        double[][] histogram = randomVariableX.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> seriesForHistogram = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            seriesForHistogram.add(new Point2D(histogram[0][i], histogram[1][i]));
        }
        ArrayList<Point2D> seriesForScatter = new ArrayList<Point2D>();
        for (int i = 0; i < randomVariableX.size(); ++i) {
            seriesForScatter.add(new Point2D(randomVariableX.get(i), randomVariableY.get(i)));
        }
        NumberAxis domainAxis = new NumberAxis("underlying value", xmin, xmax);
        NumberAxis rangeAxisHistogram = new NumberAxis("frequency", null, null);
        NumberAxis rangeAxisScatter = new NumberAxis("value", null, null);
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", seriesForScatter, domainAxis, rangeAxisScatter, new GraphStyle(new Rectangle(new Point(-2, -2), new Dimension(4, 4)), null, Color.RED)), new PlotablePoints2D("Histogram", seriesForHistogram, domainAxis, rangeAxisHistogram, new GraphStyle(new Rectangle(2, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        return new Plot2D(plotables);
    }

    public static Plot2D createPlotOfHistogram(RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogram = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            series.add(new Point2D(histogram[0][i], histogram[1][i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        return new Plot2D(plotables);
    }

    public static Plot2D updatePlotOfHistogram(Plot2D historgram, RandomVariable randomVariable, int numberOfPoints, double standardDeviations) {
        double[][] histogram = randomVariable.getHistogram(numberOfPoints, standardDeviations);
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < histogram[0].length; ++i) {
            series.add(new Point2D(histogram[0][i], histogram[1][i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Histogram", series, new GraphStyle(new Rectangle(10, 2), null, Color.DARK_GRAY, Color.LIGHT_GRAY)));
        historgram.update(plotables);
        return historgram;
    }

    public static Plot2D createPlotScatter(RandomVariable x, RandomVariable y, double xmin, double xmax) {
        double[] xValues = x.getRealizations();
        double[] yValues = y.getRealizations();
        ArrayList<Point2D> series = new ArrayList<Point2D>();
        for (int i = 0; i < xValues.length; ++i) {
            series.add(new Point2D(xValues[i], yValues[i]));
        }
        List<Plotable2D> plotables = Arrays.asList(new PlotablePoints2D("Scatter", series, new GraphStyle(new Rectangle(1, 1), null, null)));
        return new Plot2D(plotables);
    }
}

