/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableFunction2D;
import net.finmath.plots.Point2D;

public class Plot2DFX
implements Plot {
    private List<Plotable2D> plotables;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private NumberFormat xAxisNumberFormat;
    private NumberFormat yAxisNumberFormat;
    private Boolean isLegendVisible = false;
    LineChart<Number, Number> chart;
    private final Object updateLock = new Object();

    public Plot2DFX(List<Plotable2D> plotables) {
        this.plotables = plotables;
    }

    public Plot2DFX(double xmin, double xmax, int numberOfPointsX, DoubleUnaryOperator function) {
        this(xmin, xmax, numberOfPointsX, Collections.singletonList(new Named<DoubleUnaryOperator>("", function)));
    }

    public Plot2DFX(double xmin, double xmax, int numberOfPointsX, List<Named<DoubleUnaryOperator>> doubleUnaryOperators) {
        this(doubleUnaryOperators.stream().map(namedFunction -> new PlotableFunction2D(xmin, xmax, numberOfPointsX, (Named<DoubleUnaryOperator>)namedFunction, null)).collect(Collectors.toList()));
    }

    public Plot2DFX() {
        this(null);
    }

    private void init() {
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel(this.xAxisLabel);
        yAxis.setLabel(this.yAxisLabel);
        this.chart = new LineChart((Axis)xAxis, (Axis)yAxis);
        this.update();
    }

    private void update() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String rgba;
                javafx.scene.paint.Color color;
                if (Plot2DFX.this.plotables == null) {
                    return;
                }
                Plot2DFX.this.chart.setTitle(Plot2DFX.this.title);
                for (int functionIndex = 0; functionIndex < Plot2DFX.this.plotables.size(); ++functionIndex) {
                    Plotable2D plotable = Plot2DFX.this.plotables.get(functionIndex);
                    GraphStyle style = plotable.getStyle();
                    color = Plot2DFX.this.getColor(style);
                    if (color == null) {
                        color = Plot2DFX.this.getDefaultColor(functionIndex);
                    }
                    rgba = String.format("%d, %d, %d, %f", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), Float.valueOf((float)color.getOpacity()));
                    List<Point2D> plotableSeries = plotable.getSeries();
                    XYChart.Series series = null;
                    if (functionIndex < Plot2DFX.this.chart.getData().size()) {
                        series = (XYChart.Series)Plot2DFX.this.chart.getData().get(functionIndex);
                    }
                    if (series == null) {
                        series = new XYChart.Series();
                        Plot2DFX.this.chart.getData().add(functionIndex, (Object)series);
                    }
                    series.setName(plotable.getName());
                    for (int i = 0; i < plotableSeries.size(); ++i) {
                        XYChart.Data data = null;
                        if (i < series.getData().size()) {
                            data = (XYChart.Data)series.getData().get(i);
                        }
                        if (data == null) {
                            data = new XYChart.Data((Object)plotableSeries.get(i).getX(), (Object)plotableSeries.get(i).getY());
                            if (style != null && style.getShape() != null) {
                                data.setNode((Node)new Circle(6.0, (Paint)color));
                            }
                            series.getData().add(i, (Object)data);
                        }
                        data.setXValue((Object)plotableSeries.get(i).getX());
                        data.setYValue((Object)plotableSeries.get(i).getY());
                    }
                    if (style != null && style.getStroke() != null) {
                        series.getNode().setStyle("-fx-stroke: rgba(" + rgba + ");");
                        continue;
                    }
                    series.getNode().setStyle("-fx-stroke: none;");
                }
                Node[] legendItems = Plot2DFX.this.chart.lookupAll(".chart-legend-item-symbol").toArray(new Node[0]);
                for (int i = 0; i < legendItems.length; ++i) {
                    Node legendItemNode = legendItems[i];
                    color = Plot2DFX.this.getDefaultColor(i);
                    rgba = String.format("%d, %d, %d, %f", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0), Float.valueOf((float)color.getOpacity()));
                    legendItemNode.setStyle("-fx-background-color: rgba(" + rgba + ");");
                    Plot2DFX.this.chart.applyCss();
                }
                Plot2DFX.this.chart.applyCss();
            }
        });
    }

    private javafx.scene.paint.Color getColor(GraphStyle style) {
        Color awtColor = style != null ? style.getColor() : null;
        javafx.scene.paint.Color color = null;
        if (awtColor != null) {
            color = new javafx.scene.paint.Color((double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0, (double)awtColor.getAlpha() / 255.0);
        }
        return color;
    }

    private javafx.scene.paint.Color getDefaultColor(int functionIndex) {
        switch (functionIndex) {
            case 0: {
                return new javafx.scene.paint.Color(1.0, 0.0, 0.0, 1.0);
            }
            case 1: {
                return new javafx.scene.paint.Color(0.0, 1.0, 0.0, 1.0);
            }
            case 2: {
                return new javafx.scene.paint.Color(0.0, 0.0, 1.0, 1.0);
            }
        }
        return new javafx.scene.paint.Color(0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FX");
                final JFXPanel fxPanel = new JFXPanel();
                frame.add((Component)fxPanel);
                frame.setVisible(true);
                frame.setSize(800, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Plot2DFX.this.init();
                        fxPanel.setScene(new Scene(Plot2DFX.this.chart, 800.0, 600.0));
                    }
                });
                Plot2DFX.this.update();
            }
        });
    }

    public Chart get() {
        this.init();
        return this.chart;
    }

    @Override
    public void saveAsJPG(File file, int width, int height) throws IOException {
    }

    public void saveAsPNG(final File file, final int width, final int height) throws IOException {
        if (this.chart == null) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Plot2DFX.this.chart.setAnimated(false);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                    BufferedImage imageWithAlpha = new BufferedImage(width, height, 2);
                    Graphics2D g2 = imageWithAlpha.createGraphics();
                    Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
                    WritableImage image = Plot2DFX.this.chart.getScene().snapshot(null);
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", out);
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void saveAsPDF(File file, int width, int height) throws IOException {
    }

    @Override
    public void saveAsSVG(File file, int width, int height) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot2DFX update(List<Plotable2D> plotables) {
        this.plotables = plotables;
        Object object = this.updateLock;
        synchronized (object) {
            if (this.chart != null) {
                this.update();
            }
        }
        return this;
    }

    @Override
    public Plot2DFX setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Plot2DFX setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public Plot2DFX setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    public Plot2DFX setYAxisRange(Double min, Double max) {
        if (this.chart == null || this.chart.getYAxis() == null) {
            return this;
        }
        if (min == null || max == null) {
            this.chart.getYAxis().setAutoRanging(true);
        } else {
            this.chart.getYAxis().setAutoRanging(false);
            ((NumberAxis)this.chart.getYAxis()).setLowerBound(min.doubleValue());
            ((NumberAxis)this.chart.getYAxis()).setUpperBound(max.doubleValue());
        }
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        throw new UnsupportedOperationException("The 2D plot does not suport a z-axis. Try 3D plot instead.");
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }
}

