/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.FlowPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.plots.Category2D;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Plot2DBarFX;
import net.finmath.plots.Plot2DFX;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableCategories;
import net.finmath.plots.Point2D;

public class SmartDerivativeContractVisualization {
    private List<Point2D> seriesMarketValues;
    Plot2DBarFX plot;
    Plot2DFX plot2;

    public static void main(String[] args) throws Exception {
        SmartDerivativeContractVisualization sdcVisual = new SmartDerivativeContractVisualization();
        sdcVisual.start();
        double marginBuffer = 50.0;
        Random random = new Random(3413L);
        Double marketValue = 0.0;
        for (int i = 0; i < 100; ++i) {
            double marginCall = 90.0 * random.nextDouble() - 45.0;
            marketValue = marketValue + marginCall;
            sdcVisual.updateWithValue(marginBuffer, i, marketValue, marginCall);
            Thread.sleep(2000L);
            sdcVisual.updateWithValue(marginBuffer, i, null, 0.0);
        }
    }

    public void start() throws Exception {
        this.seriesMarketValues = new ArrayList<Point2D>();
        this.plot = new Plot2DBarFX(null, "Smart Contract Accounts", "Account", "Value", new DecimalFormat("####.00"), 0.0, 150.0, 10.0, false);
        this.plot2 = new Plot2DFX();
        this.plot2.setIsLegendVisible(false);
        this.plot2.setTitle("Market Value");
        this.plot2.setXAxisLabel("Date");
        this.plot2.setYAxisLabel("Market Value");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("FX");
                final JFXPanel fxPanel = new JFXPanel();
                frame.add((Component)fxPanel);
                frame.setVisible(true);
                frame.setSize(1600, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FlowPane root = new FlowPane();
                        root.getChildren().addAll((Object[])new Node[]{new Group(new Node[]{SmartDerivativeContractVisualization.this.plot.get()}), SmartDerivativeContractVisualization.this.plot2.get()});
                        Scene scene = new Scene((Parent)root, 1600.0, 600.0);
                        scene.getStylesheets().add((Object)"barchart.css");
                        fxPanel.setScene(scene);
                    }
                });
            }
        });
    }

    void updateWithValue(double base, double x, Double value, double increment) throws InterruptedException {
        final ArrayList<Category2D> density1 = new ArrayList<Category2D>();
        density1.add(new Category2D("Us", base + Math.min(0.0, increment)));
        density1.add(new Category2D("Counterpart", base + Math.min(0.0, -increment)));
        final ArrayList<Category2D> density2 = new ArrayList<Category2D>();
        density2.add(new Category2D("Us", -Math.min(0.0, increment)));
        density2.add(new Category2D("Counterpart", -Math.min(0.0, -increment)));
        final ArrayList<Category2D> density3 = new ArrayList<Category2D>();
        density3.add(new Category2D("Us", Math.max(0.0, increment)));
        density3.add(new Category2D("Counterpart", Math.max(0.0, -increment)));
        ArrayList<PlotableCategories> plotables = new ArrayList<PlotableCategories>();
        plotables.add(new PlotableCategories(){

            @Override
            public String getName() {
                return "Margin";
            }

            @Override
            public GraphStyle getStyle() {
                return new GraphStyle(new Ellipse2D.Float(-1.0f, -1.0f, 2.0f, 2.0f), new BasicStroke(1.0f), new Color(0.0f, 0.0f, 1.0f));
            }

            @Override
            public List<Category2D> getSeries() {
                return density1;
            }
        });
        plotables.add(new PlotableCategories(){

            @Override
            public String getName() {
                return "Pay";
            }

            @Override
            public GraphStyle getStyle() {
                return null;
            }

            @Override
            public List<Category2D> getSeries() {
                return density2;
            }
        });
        plotables.add(new PlotableCategories(){

            @Override
            public String getName() {
                return "Receive";
            }

            @Override
            public GraphStyle getStyle() {
                return null;
            }

            @Override
            public List<Category2D> getSeries() {
                return density3;
            }
        });
        this.plot.update(plotables);
        if (value != null) {
            ArrayList<Plotable2D> plotables2 = new ArrayList<Plotable2D>();
            plotables2.add(new Plotable2D(){

                @Override
                public String getName() {
                    return "Market Value";
                }

                @Override
                public GraphStyle getStyle() {
                    return new GraphStyle(new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f), new BasicStroke(1.0f), new Color(1.0f, 0.0f, 0.0f));
                }

                @Override
                public List<Point2D> getSeries() {
                    return SmartDerivativeContractVisualization.this.seriesMarketValues;
                }
            });
            this.seriesMarketValues.add(new Point2D(x, value));
            this.plot2.update(plotables2);
        }
        Thread.sleep(500L);
    }
}

