/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.util.function.DoubleBinaryOperator;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.plots.Named;
import net.finmath.plots.Plot3D;

public class Plot3DDemo {
    public static void main(String[] args) throws Exception {
        double initialStockValue = 100.0;
        double riskFreeRate = 0.04;
        double volatility = 0.4;
        DoubleBinaryOperator function = (strike, timeToMaturity) -> {
            double optionMaturity = timeToMaturity;
            double optionStrike = strike;
            double z = AnalyticFormulas.blackScholesOptionValue((double)100.0, (double)0.04, (double)0.4, (double)optionMaturity, (double)optionStrike);
            return z;
        };
        Plot3D plot = new Plot3D(0.0, 300.0, 0.0, 10.0, 100, 100, new Named<DoubleBinaryOperator>("Black Scholes European Option Value", function));
        plot.setXAxisLabel("strike").setYAxisLabel("time to maturity").setZAxisLabel("value");
        plot.show();
    }
}

