/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.demo;

import java.util.function.DoubleFunction;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.plots.Named;
import net.finmath.plots.PlotProcess2D;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class Plot2DDemoBlackScholesPaths {
    public static void main(String[] args) throws Exception {
        double initialValue = 100.0;
        double riskFreeRate = 0.04;
        double volatility = 0.4;
        int numberOfTimeSteps = 100;
        double deltaT = 0.1;
        int numberOfPaths = 1000;
        TimeDiscretization timeDiscretization = new TimeDiscretization(0.0, 100, 0.1);
        MonteCarloBlackScholesModel blackScholesMonteCarlo = new MonteCarloBlackScholesModel((TimeDiscretizationInterface)timeDiscretization, 1000, 100.0, 0.04, 0.4);
        DoubleFunction<RandomVariableInterface> function = arg_0 -> Plot2DDemoBlackScholesPaths.lambda$main$0((AssetModelMonteCarloSimulationInterface)blackScholesMonteCarlo, arg_0);
        PlotProcess2D plot = new PlotProcess2D((TimeDiscretizationInterface)timeDiscretization, new Named<DoubleFunction<RandomVariableInterface>>("Black-Scholes", function), 100);
        plot.setTitle("Black-Scholes Model Path").setXAxisLabel("time").setYAxisLabel("value");
        plot.show();
    }

    private static /* synthetic */ RandomVariableInterface lambda$main$0(AssetModelMonteCarloSimulationInterface blackScholesMonteCarlo, double time) {
        try {
            return blackScholesMonteCarlo.getAssetValue(time, 0);
        }
        catch (ArrayIndexOutOfBoundsException | CalculationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

