/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.opencl.montecarlo;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomVariable;
import org.apache.commons.io.IOUtils;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;
import org.jocl.cl_program;
import org.jocl.cl_queue_properties;

public class RandomVariableOpenCL
implements RandomVariable {
    private static final Logger logger = Logger.getLogger("net.finmath");
    private static DeviceMemoryPool deviceMemoryPool = new DeviceMemoryPool();
    private static final long serialVersionUID = 7620120320663270600L;
    private final double time;
    private static final int typePriorityDefault = 20;
    private final int typePriority;
    private final DevicePointerReference realizations;
    private final long size;
    private final double valueIfNonStochastic;
    private static final ExecutorService deviceExecutor = Executors.newSingleThreadExecutor();
    private static cl_device_id device;
    private static cl_context context;
    private static cl_command_queue commandQueue;
    private static cl_kernel capByScalar;
    private static cl_kernel floorByScalar;
    private static cl_kernel addScalar;
    private static cl_kernel subScalar;
    private static cl_kernel busScalar;
    private static cl_kernel multScalar;
    private static cl_kernel divScalar;
    private static cl_kernel vidScalar;
    private static cl_kernel cuPow;
    private static cl_kernel cuSqrt;
    private static cl_kernel cuExp;
    private static cl_kernel cuLog;
    private static cl_kernel invert;
    private static cl_kernel cuAbs;
    private static cl_kernel cap;
    private static cl_kernel cuFloor;
    private static cl_kernel add;
    private static cl_kernel sub;
    private static cl_kernel mult;
    private static cl_kernel cuDiv;
    private static cl_kernel accrue;
    private static cl_kernel discount;
    private static cl_kernel addProduct;
    private static cl_kernel addProductVectorScalar;
    private static cl_kernel reducePartial;
    private static cl_kernel reduceFloatVectorToDoubleScalar;
    private static long reduceGridSize;

    private static RandomVariableOpenCL of(double time, DevicePointerReference realizations, long size, int typePriority) {
        RandomVariableOpenCL randomVariableOpenCL = new RandomVariableOpenCL(time, realizations, size, typePriority);
        return randomVariableOpenCL;
    }

    private static RandomVariableOpenCL of(double time, DevicePointerReference realizations, long size) {
        RandomVariableOpenCL randomVariableOpenCL = new RandomVariableOpenCL(time, realizations, size, 20);
        return randomVariableOpenCL;
    }

    public static RandomVariableOpenCL of(double time, double value) {
        RandomVariableOpenCL randomVariableOpenCL = new RandomVariableOpenCL(time, value, 20);
        return randomVariableOpenCL;
    }

    private RandomVariableOpenCL(double time, DevicePointerReference realizations, long size, int typePriority) {
        this.time = time;
        this.realizations = realizations;
        this.size = size;
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = typePriority;
    }

    public RandomVariableOpenCL(double value) {
        this(-1.7976931348623157E308, value);
    }

    public RandomVariableOpenCL(double time, double value, int typePriority) {
        this.time = time;
        this.realizations = null;
        this.size = 1L;
        this.valueIfNonStochastic = value;
        this.typePriority = typePriority;
    }

    public RandomVariableOpenCL(double time, float[] realisations, int typePriority) {
        this(time, RandomVariableOpenCL.getDevicePointer(realisations), realisations.length, typePriority);
    }

    public RandomVariableOpenCL(double time, double value) {
        this(time, value, 20);
    }

    public RandomVariableOpenCL(double time, float[] realisations) {
        this(time, RandomVariableOpenCL.getDevicePointer(realisations), realisations.length, 20);
    }

    public RandomVariableOpenCL(double time, double[] realisations) {
        this(time, RandomVariableOpenCL.getFloatArray(realisations));
    }

    public RandomVariableOpenCL(float[] realisations) {
        this(0.0, realisations);
    }

    public static DevicePointerReference getDevicePointer(long size) {
        return deviceMemoryPool.getDevicePointer(size);
    }

    private static DevicePointerReference getDevicePointer(float[] values) {
        return deviceMemoryPool.getDevicePointer(values);
    }

    public static void clean() {
        deviceMemoryPool.clean();
    }

    public static void purge() {
        deviceMemoryPool.purge();
    }

    private static RandomVariableOpenCL getRandomVariableOpenCL(RandomVariable randomVariable) {
        if (randomVariable instanceof RandomVariableOpenCL) {
            return (RandomVariableOpenCL)randomVariable;
        }
        RandomVariableOpenCL randomVariableCuda = new RandomVariableOpenCL(randomVariable.getFiltrationTime(), randomVariable.getRealizations());
        return randomVariableCuda;
    }

    private static float[] getFloatArray(double[] arrayOfDouble) {
        float[] arrayOfFloat = new float[arrayOfDouble.length];
        for (int i = 0; i < arrayOfDouble.length; ++i) {
            arrayOfFloat[i] = (float)arrayOfDouble[i];
        }
        return arrayOfFloat;
    }

    private static double[] getDoubleArray(float[] arrayOfFloat) {
        double[] arrayOfDouble = new double[arrayOfFloat.length];
        for (int i = 0; i < arrayOfFloat.length; ++i) {
            arrayOfDouble[i] = arrayOfFloat[i];
        }
        return arrayOfDouble;
    }

    public boolean equals(RandomVariable randomVariable) {
        throw new UnsupportedOperationException();
    }

    public double getFiltrationTime() {
        return this.time;
    }

    public int getTypePriority() {
        return this.typePriority;
    }

    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException();
    }

    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return (int)this.size;
    }

    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double[] realizations = this.getRealizations();
        double min = Double.MAX_VALUE;
        if (realizations.length != 0) {
            min = realizations[0];
        }
        for (int i = 0; i < realizations.length; ++i) {
            min = Math.min(realizations[i], min);
        }
        return min;
    }

    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double[] realizations = this.getRealizations();
        double max = -1.7976931348623157E308;
        if (realizations.length != 0) {
            max = realizations[0];
        }
        for (int i = 0; i < realizations.length; ++i) {
            max = Math.max(realizations[i], max);
        }
        return max;
    }

    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double reduced = this.reduceToDouble();
        return reduced / (double)this.size();
    }

    public double getAverage(RandomVariable probabilities) {
        return this.mult(probabilities).getAverage();
    }

    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        return this.squared().getAverage() - average * average;
    }

    public double getVariance(RandomVariable probabilities) {
        double average = this.getAverage(probabilities);
        return this.squared().sub(average * average).getAverage(probabilities);
    }

    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    public double getQuantile(double quantile) {
        double[] realizations;
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = realizations = this.getRealizations();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - quantile) - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = this.getRealizations();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = this.getRealizations();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariable cache() {
        return this;
    }

    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.valueIfNonStochastic};
            return result;
        }
        return RandomVariableOpenCL.getDoubleArray(deviceMemoryPool.getValuesAsFloat(this.realizations, this.size()));
    }

    public Double doubleValue() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException("The random variable is non-deterministic");
    }

    public IntToDoubleFunction getOperator() {
        return null;
    }

    public DoubleStream getRealizationsStream() {
        return null;
    }

    public RandomVariable apply(DoubleUnaryOperator function) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(capByScalar, this.size, this.realizations, cap);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(floorByScalar, this.size, this.realizations, floor);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(addScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(subScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable bus(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = -this.valueIfNonStochastic + value;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(busScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(multScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(divScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable vid(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = value / this.valueIfNonStochastic;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(vidScalar, this.size, this.realizations, value);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s1(cuPow, this.size, this.realizations, exponent);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable average() {
        return RandomVariableOpenCL.of(-1.7976931348623157E308, this.getAverage());
    }

    public RandomVariable squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        return this.mult(this);
    }

    public RandomVariable sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s0(cuSqrt, this.size, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s0(invert, this.size, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s0(cuAbs, this.size, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.exp(this.valueIfNonStochastic);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s0(cuExp, this.size, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.log(this.valueIfNonStochastic);
            return RandomVariableOpenCL.of(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv1s0(cuLog, this.size, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable sin() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cos() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable add(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).add(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.add(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(add, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable sub(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.bus((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).bus(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.sub(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(sub, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable bus(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.sub((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = -this.valueIfNonStochastic + randomVariable.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).sub(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.bus(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(sub, this.size, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations, this.realizations);
        return RandomVariableOpenCL.of(this.time, result, this.size());
    }

    public RandomVariable mult(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.mult(randomVariable.doubleValue());
        }
        if (this.isDeterministic() && !randomVariable.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).mult(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(mult, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable div(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).vid(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.div(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(cuDiv, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable vid(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.doubleValue() / this.valueIfNonStochastic;
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).div(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.vid(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(cuDiv, this.size, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations, this.realizations);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable cap(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.cap((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, randomVariable.doubleValue());
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.cap(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(cap, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable floor(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.floor((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, randomVariable.doubleValue());
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(randomVariable).floor(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.floor(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s0(cuFloor, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)randomVariable).realizations);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.mult(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            return RandomVariableOpenCL.getRandomVariableOpenCL(rate.mult(periodLength).add(1.0).mult(this.valueIfNonStochastic));
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s1(accrue, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)rate).realizations, periodLength);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable discount(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).invert().mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.div(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            if (this.valueIfNonStochastic == 0.0) {
                return this;
            }
            return RandomVariableOpenCL.getRandomVariableOpenCL(rate.mult(periodLength).add(1.0)).vid(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callFunctionv2s1(discount, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)rate).realizations, periodLength);
        return RandomVariableOpenCL.of(newTime, result, this.size());
    }

    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return null;
    }

    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        if (factor1.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, factor1.getFiltrationTime());
        if (factor1.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2);
        }
        if (!this.isDeterministic() && !factor1.isDeterministic()) {
            DevicePointerReference result = deviceMemoryPool.callFunctionv2s1(addProductVectorScalar, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)factor1).realizations, factor2);
            return RandomVariableOpenCL.of(newTime, result, this.size());
        }
        return this.add(factor1.mult(factor2));
    }

    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        if (factor1.getTypePriority() > this.getTypePriority() || factor2.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(Math.max(this.time, factor1.getFiltrationTime()), factor2.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic() && factor2.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.doubleValue() * factor2.doubleValue();
            return RandomVariableOpenCL.of(newTime, newValueIfNonStochastic);
        }
        if (factor1.isDeterministic() && factor2.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2.doubleValue());
        }
        if (factor2.isDeterministic()) {
            return this.addProduct(factor1, factor2.doubleValue());
        }
        if (factor1.isDeterministic()) {
            return this.addProduct(factor2, factor1.doubleValue());
        }
        if (!(this.isDeterministic() || factor1.isDeterministic() || factor2.isDeterministic())) {
            DevicePointerReference result = deviceMemoryPool.callFunctionv3s0(addProduct, this.size, this.realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)factor1).realizations, RandomVariableOpenCL.getRandomVariableOpenCL((RandomVariable)factor2).realizations);
            return RandomVariableOpenCL.of(newTime, result, this.size());
        }
        return this.add(factor1.mult(factor2));
    }

    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.add(numerator.div(denominator));
    }

    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.sub(numerator.div(denominator));
    }

    public RandomVariable isNaN() {
        return null;
    }

    private double reduceToDouble() {
        long numberOfGroups = 1L;
        long numberOfWorkItems = reduceGridSize;
        DevicePointerReference result = RandomVariableOpenCL.getDevicePointer(2L * numberOfGroups);
        deviceExecutor.submit(() -> {
            CL.clSetKernelArg((cl_kernel)reduceFloatVectorToDoubleScalar, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)this.realizations.get()));
            CL.clSetKernelArg((cl_kernel)reduceFloatVectorToDoubleScalar, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
            CL.clSetKernelArg((cl_kernel)reduceFloatVectorToDoubleScalar, (int)2, (long)4L, (Pointer)Pointer.to((int[])new int[]{this.size()}));
            CL.clSetKernelArg((cl_kernel)reduceFloatVectorToDoubleScalar, (int)3, (long)(2L * numberOfWorkItems * 4L), null);
            long[] globalWorkSize = new long[]{reduceGridSize};
            long[] localWorkSize = new long[]{reduceGridSize};
            try {
                CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)reduceFloatVectorToDoubleScalar, (int)1, null, (long[])globalWorkSize, (long[])localWorkSize, (int)0, null, null);
            }
            catch (Exception e) {
                logger.severe("Command reduceFloatVectorToDoubleScalar failed.");
                throw new RuntimeException(e.getCause());
            }
        });
        return deviceMemoryPool.getValuesAsFloat(result, 1)[0];
    }

    private RandomVariableOpenCL reduceBySize(int bySize) {
        int blockSizeX = bySize;
        int gridSizeX = (int)Math.ceil((double)this.size() / 2.0 / (double)blockSizeX);
        DevicePointerReference reduceVector = RandomVariableOpenCL.getDevicePointer(gridSizeX);
        deviceMemoryPool.callFunction(reducePartial, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject)this.realizations.get()), Pointer.to((NativePointerObject)reduceVector.get())}, new int[]{4, Sizeof.cl_mem, Sizeof.cl_mem}, gridSizeX, blockSizeX, blockSizeX * 2 * 3);
        return RandomVariableOpenCL.of(-1.7976931348623157E308, reduceVector, gridSizeX);
    }

    private static class DeviceMemoryPool {
        private final Object lock = new Object();
        private final Map<Integer, ReferenceQueue<DevicePointerReference>> vectorsToRecycleReferenceQueueMap = new ConcurrentHashMap<Integer, ReferenceQueue<DevicePointerReference>>();
        private final Map<WeakReference<DevicePointerReference>, cl_mem> vectorsInUseReferenceMap = new ConcurrentHashMap<WeakReference<DevicePointerReference>, cl_mem>();
        private final float vectorsRecyclerPercentageFreeToStartGC = 0.15f;
        private final float vectorsRecyclerPercentageFreeToWaitForGC = 0.05f;
        private final long vectorsRecyclerMaxTimeOutMillis = 1000L;
        private long deviceAllocMemoryBytes = 0L;
        private long deviceMaxMemoryBytes;

        DeviceMemoryPool() {
            cl_program cpProgram;
            String source;
            long deviceType;
            String openCLDeviceTypeString = System.getProperty("net.finmath.montecarlo.opencl.RandomVariableOpenCL.deviceType", "GPU");
            int openCLDeviceIndex = Integer.parseInt(System.getProperty("net.finmath.montecarlo.opencl.RandomVariableOpenCL.deviceIndex", "-1"));
            logger.config("Configured class with device type " + openCLDeviceTypeString + " and device index " + openCLDeviceIndex);
            switch (openCLDeviceTypeString) {
                default: {
                    deviceType = 4L;
                    break;
                }
                case "CPU": {
                    deviceType = 2L;
                    break;
                }
                case "ALL": {
                    deviceType = -1L;
                }
            }
            boolean platformIndex = false;
            CL.setExceptionsEnabled((boolean)true);
            int[] numPlatformsArray = new int[1];
            CL.clGetPlatformIDs((int)0, null, (int[])numPlatformsArray);
            int numPlatforms = numPlatformsArray[0];
            cl_platform_id[] platforms = new cl_platform_id[numPlatforms];
            CL.clGetPlatformIDs((int)platforms.length, (cl_platform_id[])platforms, null);
            cl_platform_id platform = platforms[0];
            cl_context_properties contextProperties = new cl_context_properties();
            contextProperties.addProperty(4228L, platform);
            int[] numDevicesArray = new int[1];
            CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)0, null, (int[])numDevicesArray);
            int numDevices = numDevicesArray[0];
            logger.config("Found " + numDevices + " of device type " + openCLDeviceTypeString);
            cl_device_id[] devices = new cl_device_id[numDevices];
            CL.clGetDeviceIDs((cl_platform_id)platform, (long)deviceType, (int)numDevices, (cl_device_id[])devices, null);
            int deviceIndex = openCLDeviceIndex >= 0 ? openCLDeviceIndex : devices.length + openCLDeviceIndex;
            logger.config("Using device " + deviceIndex + " of device type " + openCLDeviceTypeString);
            device = devices[deviceIndex];
            context = CL.clCreateContext((cl_context_properties)contextProperties, (int)1, (cl_device_id[])new cl_device_id[]{device}, null, null, null);
            int[] returnCode = new int[1];
            try {
                cl_queue_properties properties = new cl_queue_properties();
                commandQueue = CL.clCreateCommandQueueWithProperties((cl_context)context, (cl_device_id)device, (cl_queue_properties)properties, null);
                logger.config("Using OpenCL 2.x");
            }
            catch (Exception e) {
                commandQueue = CL.clCreateCommandQueue((cl_context)context, (cl_device_id)device, (long)0L, (int[])returnCode);
                logger.config("Using OpenCL 1.x");
            }
            if (returnCode[0] != 0 || commandQueue == null) {
                throw new RuntimeException("Unable to create OpenCL command queue: " + returnCode[0]);
            }
            logger.fine("Created OpenCL command queue");
            String resourceName = "/net/finmath/opencl/montecarlo/RandomVariableOpenCLKernel.cl";
            try (InputStream inputStreamOfSource = RandomVariableOpenCL.class.getResourceAsStream("/net/finmath/opencl/montecarlo/RandomVariableOpenCLKernel.cl");){
                source = IOUtils.toString((InputStream)inputStreamOfSource, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.fine("Read OpenCL program");
            try {
                cpProgram = CL.clCreateProgramWithSource((cl_context)context, (int)1, (String[])new String[]{source}, null, null);
            }
            catch (Exception e) {
                logger.severe("Unable to create OpenCL program: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            CL.clBuildProgram((cl_program)cpProgram, (int)0, null, (String)"", null, null);
            logger.fine("Compiled OpenCL program");
            Function<String, cl_kernel> createKernel = kernelName -> {
                try {
                    return CL.clCreateKernel((cl_program)cpProgram, (String)kernelName, null);
                }
                catch (Exception e) {
                    logger.severe("Unable to create OpenCL kernel " + kernelName + ".\n" + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
            };
            capByScalar = createKernel.apply("capByScalar");
            floorByScalar = createKernel.apply("floorByScalar");
            addScalar = createKernel.apply("addScalar");
            subScalar = createKernel.apply("subScalar");
            busScalar = createKernel.apply("busScalar");
            multScalar = createKernel.apply("multScalar");
            divScalar = createKernel.apply("divScalar");
            vidScalar = createKernel.apply("vidScalar");
            cuPow = createKernel.apply("cuPow");
            cuSqrt = createKernel.apply("cuSqrt");
            cuExp = createKernel.apply("cuExp");
            cuLog = createKernel.apply("cuLog");
            invert = createKernel.apply("invert");
            cuAbs = createKernel.apply("cuAbs");
            cap = createKernel.apply("cap");
            cuFloor = createKernel.apply("cuFloor");
            add = createKernel.apply("add");
            sub = createKernel.apply("sub");
            mult = createKernel.apply("mult");
            cuDiv = createKernel.apply("cuDiv");
            accrue = createKernel.apply("accrue");
            discount = createKernel.apply("discount");
            addProduct = createKernel.apply("addProduct");
            addProductVectorScalar = createKernel.apply("addProduct_vs");
            reduceFloatVectorToDoubleScalar = createKernel.apply("reduceFloatVectorToDoubleScalar");
            logger.fine("Created all OpenCL kernels");
            long[] workGroupSize = new long[1];
            CL.clGetKernelWorkGroupInfo((cl_kernel)reduceFloatVectorToDoubleScalar, (cl_device_id)device, (int)4528, (long)8L, (Pointer)Pointer.to((long[])workGroupSize), null);
            reduceGridSize = workGroupSize[0];
            long[] deviceMaxMemoryBytesResult = new long[1];
            try {
                CL.clGetDeviceInfo((cl_device_id)device, (int)4127, (long)8L, (Pointer)Pointer.to((long[])deviceMaxMemoryBytesResult), null);
                this.deviceMaxMemoryBytes = deviceMaxMemoryBytesResult[0];
                logger.config("OpenCL reported " + this.deviceMaxMemoryBytes + " bytes.");
            }
            catch (Exception e) {
                logger.warning("Failed to get available memory for OpenCL.\n" + e.getStackTrace());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    this.purge();
                    deviceExecutor.shutdown();
                    try {
                        deviceExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }));
            logger.config("OpenCL initialized");
        }

        public DevicePointerReference getDevicePointer(long size) {
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Memory pool stats: ");
                stringBuilder.append("  vector sizes: ");
                for (Map.Entry<Integer, ReferenceQueue<DevicePointerReference>> entry : this.vectorsToRecycleReferenceQueueMap.entrySet()) {
                    stringBuilder.append("    " + entry.getKey());
                }
                stringBuilder.append("  total number of vectors: " + this.vectorsInUseReferenceMap.size());
                logger.finest(stringBuilder.toString());
            }
            cl_mem cuDevicePtr = null;
            ReferenceQueue vectorsToRecycleReferenceQueue = this.vectorsToRecycleReferenceQueueMap.computeIfAbsent(new Integer((int)size), key -> {
                logger.fine("Creating reference queue for vector size " + size);
                return new ReferenceQueue();
            });
            Reference reference = vectorsToRecycleReferenceQueue.poll();
            if (reference != null) {
                cuDevicePtr = this.vectorsInUseReferenceMap.remove(reference);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Recycling (1) device pointer " + cuDevicePtr + " from " + reference);
                }
            } else {
                float deviceFreeMemPercentage = this.getDeviceFreeMemPercentage();
                if (deviceFreeMemPercentage < 0.15f && deviceFreeMemPercentage >= 0.05f) {
                    System.gc();
                    System.runFinalization();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.fine("Device free memory " + deviceFreeMemPercentage * 100.0f + "%");
                    }
                    reference = vectorsToRecycleReferenceQueue.poll();
                }
                if (reference == null && deviceFreeMemPercentage < 0.05f) {
                    System.gc();
                    long timeOut = 1L;
                    while (reference == null && timeOut < 1000L) {
                        try {
                            reference = vectorsToRecycleReferenceQueue.remove(timeOut);
                            timeOut *= 4L;
                        }
                        catch (IllegalArgumentException | InterruptedException exception) {
                            // empty catch block
                        }
                        logger.fine("Waiting for GC. Device free memory " + deviceFreeMemPercentage * 100.0f + "%");
                    }
                    if (reference == null) {
                        logger.fine("Last resort: Cleaning all unused vectors on device. Device free memory " + deviceFreeMemPercentage * 100.0f + "%");
                        this.clean();
                    }
                }
                if (reference != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Recycling (2) device pointer " + cuDevicePtr + " from " + reference);
                    }
                    cuDevicePtr = this.vectorsInUseReferenceMap.remove(reference);
                }
            }
            if (cuDevicePtr == null) {
                try {
                    int[] errorCode = new int[1];
                    cuDevicePtr = deviceExecutor.submit(() -> CL.clCreateBuffer((cl_context)context, (long)1L, (long)(size * 4L), null, (int[])errorCode)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.severe("Failed to allocate device vector with size=" + size + ". Cause: " + e.getCause());
                }
                if (cuDevicePtr == null) {
                    logger.severe("Failed to allocate device vector with size=" + size);
                    throw new OutOfMemoryError("Failed to allocate device vector with size=" + size);
                }
                this.deviceAllocMemoryBytes += size * 4L;
            }
            DevicePointerReference devicePointerReference = new DevicePointerReference(cuDevicePtr);
            this.vectorsInUseReferenceMap.put(new WeakReference<DevicePointerReference>(devicePointerReference, vectorsToRecycleReferenceQueue), cuDevicePtr);
            return devicePointerReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clean() {
            Object object = this.lock;
            synchronized (object) {
                logger.fine("Cleaning device pointers");
                for (Map.Entry<Integer, ReferenceQueue<DevicePointerReference>> entry : this.vectorsToRecycleReferenceQueueMap.entrySet()) {
                    Reference<DevicePointerReference> reference;
                    int size = entry.getKey();
                    ReferenceQueue<DevicePointerReference> vectorsToRecycleReferenceQueue = entry.getValue();
                    while ((reference = vectorsToRecycleReferenceQueue.poll()) != null) {
                        cl_mem cuDevicePtr = this.vectorsInUseReferenceMap.remove(reference);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Freeing device pointer " + cuDevicePtr + " from " + reference);
                        }
                        try {
                            deviceExecutor.submit(() -> CL.clReleaseMemObject((cl_mem)cuDevicePtr)).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.severe("Unable to free pointer " + cuDevicePtr + " from " + reference);
                            throw new RuntimeException(e.getCause());
                        }
                        this.deviceAllocMemoryBytes -= (long)(size * 4);
                    }
                }
            }
        }

        public void purge() {
            System.gc();
            System.runFinalization();
            this.clean();
            logger.fine("OpenCL vectors in use: " + this.vectorsInUseReferenceMap.size() + ". Available device memory: " + this.getDeviceFreeMemPercentage() * 100.0f + "%");
        }

        private float getDeviceFreeMemPercentage() {
            float freeRate = 1.0f - 1.1f * (float)this.deviceAllocMemoryBytes / (float)this.deviceMaxMemoryBytes;
            return freeRate;
        }

        public DevicePointerReference getDevicePointer(float[] values) {
            DevicePointerReference devicePointerReference = this.getDevicePointer(values.length);
            if (devicePointerReference.get() == null) {
                throw new NullPointerException("Unable to get device pointer.");
            }
            try {
                deviceExecutor.submit(() -> CL.clEnqueueWriteBuffer((cl_command_queue)commandQueue, (cl_mem)devicePointerReference.get(), (boolean)true, (long)0L, (long)((long)values.length * 4L), (Pointer)Pointer.to((float[])values), (int)0, null, null)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.severe("Unable to a create device pointer for vector of size " + values.length);
                throw new RuntimeException(e.getCause());
            }
            return devicePointerReference;
        }

        public float[] getValuesAsFloat(DevicePointerReference devicePtr, int size) {
            float[] result = new float[size];
            try {
                deviceExecutor.submit(() -> CL.clEnqueueReadBuffer((cl_command_queue)commandQueue, (cl_mem)devicePtr.get(), (boolean)true, (long)0L, (long)(size * 4), (Pointer)Pointer.to((float[])result), (int)0, null, null)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.severe("Unable to a create device pointer for vector of size " + size);
                throw new RuntimeException(e.getCause());
            }
            return result;
        }

        public DevicePointerReference callFunctionv1s0(cl_kernel function, long resultSize, DevicePointerReference argument1) {
            DevicePointerReference result = this.getDevicePointer(resultSize);
            deviceExecutor.submit(() -> {
                CL.clSetKernelArg((cl_kernel)function, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument1.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
                long[] globalWorkSize = new long[]{resultSize};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
            return result;
        }

        public DevicePointerReference callFunctionv2s0(cl_kernel function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2) {
            DevicePointerReference result = this.getDevicePointer(resultSize);
            deviceExecutor.submit(() -> {
                CL.clSetKernelArg((cl_kernel)function, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument1.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument2.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)2, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
                long[] globalWorkSize = new long[]{resultSize};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
            return result;
        }

        public DevicePointerReference callFunctionv3s0(cl_kernel function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2, DevicePointerReference argument3) {
            DevicePointerReference result = this.getDevicePointer(resultSize);
            deviceExecutor.submit(() -> {
                CL.clSetKernelArg((cl_kernel)function, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument1.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument2.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)2, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument3.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)3, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
                long[] globalWorkSize = new long[]{resultSize};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
            return result;
        }

        public DevicePointerReference callFunctionv1s1(cl_kernel function, long resultSize, DevicePointerReference argument1, double value) {
            DevicePointerReference result = this.getDevicePointer(resultSize);
            deviceExecutor.submit(() -> {
                CL.clSetKernelArg((cl_kernel)function, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument1.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)1, (long)4L, (Pointer)Pointer.to((float[])new float[]{(float)value}));
                CL.clSetKernelArg((cl_kernel)function, (int)2, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
                long[] globalWorkSize = new long[]{resultSize};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
            return result;
        }

        public DevicePointerReference callFunctionv2s1(cl_kernel function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2, double value) {
            DevicePointerReference result = this.getDevicePointer(resultSize);
            deviceExecutor.submit(() -> {
                CL.clSetKernelArg((cl_kernel)function, (int)0, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument1.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)1, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)argument2.get()));
                CL.clSetKernelArg((cl_kernel)function, (int)2, (long)4L, (Pointer)Pointer.to((float[])new float[]{(float)value}));
                CL.clSetKernelArg((cl_kernel)function, (int)3, (long)Sizeof.cl_mem, (Pointer)Pointer.to((NativePointerObject)result.get()));
                long[] globalWorkSize = new long[]{resultSize};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
            return result;
        }

        public void callFunction(cl_kernel function, long resultSize, Pointer[] arguments, int[] argumentSizes) {
            int blockSizeX = 1024;
            int gridSizeX = (int)Math.ceil((double)resultSize / 1024.0);
            this.callFunction(function, arguments, argumentSizes, gridSizeX, 1024, 0);
        }

        public void callFunction(cl_kernel function, Pointer[] arguments, int[] argumentSizes, int gridSizeX, int blockSizeX, int sharedMemorySize) {
            deviceExecutor.submit(() -> {
                for (int i = 0; i < arguments.length; ++i) {
                    CL.clSetKernelArg((cl_kernel)function, (int)i, (long)argumentSizes[i], (Pointer)arguments[i]);
                }
                long[] globalWorkSize = new long[]{gridSizeX * blockSizeX};
                long[] localWorkSize = null;
                try {
                    CL.clEnqueueNDRangeKernel((cl_command_queue)commandQueue, (cl_kernel)function, (int)1, null, (long[])globalWorkSize, localWorkSize, (int)0, null, null);
                }
                catch (Exception e) {
                    logger.severe("Command " + function + " failed.");
                    throw new RuntimeException(e.getCause());
                }
            });
        }
    }

    private static class DevicePointerReference {
        private final cl_mem devicePointer;

        DevicePointerReference(cl_mem devicePointer) {
            this.devicePointer = devicePointer;
        }

        public cl_mem get() {
            return this.devicePointer;
        }
    }
}

