/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.opencl.cpu.montecarlo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomVariable;
import org.apache.commons.math3.util.FastMath;

public class RandomVariableFromFloatArray
implements RandomVariable {
    private static final long serialVersionUID = -1352953450936857742L;
    private static final int typePriorityDefault = 1;
    private final int typePriority;
    private final double time;
    private final float[] realizations;
    private final double valueIfNonStochastic;

    public RandomVariableFromFloatArray(RandomVariable value) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : RandomVariableFromFloatArray.getFloatArray(value.getRealizations());
        this.valueIfNonStochastic = value.isDeterministic() ? value.get(0) : Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromFloatArray(double value) {
        this(Double.NEGATIVE_INFINITY, value, 1);
    }

    public RandomVariableFromFloatArray(RandomVariable value, DoubleUnaryOperator function) {
        this.time = value.getFiltrationTime();
        this.realizations = value.isDeterministic() ? null : RandomVariableFromFloatArray.getFloatArray(value.getRealizationsStream().map(function).toArray());
        this.valueIfNonStochastic = value.isDeterministic() ? function.applyAsDouble(value.get(0)) : Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromFloatArray(double time, double value, int typePriority) {
        this.time = time;
        this.realizations = null;
        this.valueIfNonStochastic = value;
        this.typePriority = typePriority;
    }

    public RandomVariableFromFloatArray(double time, double value) {
        this(time, value, 1);
    }

    public RandomVariableFromFloatArray(double time, float[] newRealizations) {
        this(time, newRealizations, 1);
    }

    @Deprecated
    public RandomVariableFromFloatArray(double time, int numberOfPath, double value) {
        this.time = time;
        this.realizations = new float[numberOfPath];
        Arrays.fill(this.realizations, (float)value);
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = 1;
    }

    public RandomVariableFromFloatArray(double time, float[] realisations, int typePriority) {
        this.time = time;
        this.realizations = realisations;
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = typePriority;
    }

    public RandomVariableFromFloatArray(double time, double[] realisations) {
        this(time, RandomVariableFromFloatArray.getFloatArray(realisations), 1);
    }

    public RandomVariableFromFloatArray(double time, final IntToDoubleFunction realizations, int size, int typePriority) {
        this.time = time;
        this.realizations = size == 1 ? null : new float[size];
        double d = this.valueIfNonStochastic = size == 1 ? realizations.applyAsDouble(0) : Double.NaN;
        if (size > 1) {
            IntStream.range(0, size).parallel().forEach(new IntConsumer(){

                @Override
                public void accept(int i) {
                    RandomVariableFromFloatArray.this.realizations[i] = (float)realizations.applyAsDouble(i);
                }
            });
        }
        this.typePriority = typePriority;
    }

    public RandomVariableFromFloatArray(double time, IntToDoubleFunction realizations, int size) {
        this(time, realizations, size, 1);
    }

    private static float[] getFloatArray(double[] arrayOfDouble) {
        float[] arrayOfFloat = new float[arrayOfDouble.length];
        for (int i = 0; i < arrayOfDouble.length; ++i) {
            arrayOfFloat[i] = (float)arrayOfDouble[i];
        }
        return arrayOfFloat;
    }

    private double[] getDoubleArray(float[] arrayOfFloat) {
        double[] arrayOfDouble = new double[arrayOfFloat.length];
        for (int i = 0; i < arrayOfFloat.length; ++i) {
            arrayOfDouble[i] = arrayOfFloat[i];
        }
        return arrayOfDouble;
    }

    public boolean equals(RandomVariable randomVariable) {
        if (this.time != randomVariable.getFiltrationTime()) {
            return false;
        }
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            return this.valueIfNonStochastic == randomVariable.get(0);
        }
        if (this.isDeterministic() != randomVariable.isDeterministic()) {
            return false;
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            if ((double)this.realizations[i] == randomVariable.get(i)) continue;
            return false;
        }
        return true;
    }

    public double getFiltrationTime() {
        return this.time;
    }

    public int getTypePriority() {
        return this.typePriority;
    }

    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        return this.realizations[pathOrState];
    }

    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return this.realizations.length;
    }

    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double min = Double.MAX_VALUE;
        if (this.realizations.length != 0) {
            min = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            min = Math.min((double)this.realizations[i], min);
        }
        return min;
    }

    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double max = -1.7976931348623157E308;
        if (this.realizations.length != 0) {
            max = this.realizations[0];
        }
        for (int i = 0; i < this.realizations.length; ++i) {
            max = Math.max((double)this.realizations[i], max);
        }
        return max;
    }

    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    public double getAverage(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic * probabilities.getAverage();
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double sum = 0.0;
        double error = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = (double)this.realizations[i] * probabilities.get(i) - error;
            double newSum = sum + value;
            error = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    public double getVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = ((double)this.realizations[i] - average) * ((double)this.realizations[i] - average) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum / (double)this.realizations.length;
    }

    public double getVariance(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage(probabilities);
        double sum = 0.0;
        double errorOfSum = 0.0;
        for (int i = 0; i < this.realizations.length; ++i) {
            double value = ((double)this.realizations[i] - average) * ((double)this.realizations[i] - average) * probabilities.get(i) - errorOfSum;
            double newSum = sum + value;
            errorOfSum = newSum - sum - value;
            sum = newSum;
        }
        return sum;
    }

    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        float[] realizationsSorted = (float[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantile - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        float[] realizationsSorted = (float[])this.realizations.clone();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += (double)realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            float[] realizationsSorted = (float[])this.realizations.clone();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && (double)realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariable cache() {
        return this;
    }

    public DoubleStream getRealizationsStream() {
        if (this.isDeterministic()) {
            return DoubleStream.generate(new DoubleSupplier(){

                @Override
                public double getAsDouble() {
                    return RandomVariableFromFloatArray.this.valueIfNonStochastic;
                }
            });
        }
        return Arrays.stream(this.getDoubleArray(this.realizations));
    }

    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        return this.getDoubleArray(this.realizations);
    }

    public Double doubleValue() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException("The random variable is non-deterministic");
    }

    public IntToDoubleFunction getOperator() {
        if (this.isDeterministic()) {
            return new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int i) {
                    return RandomVariableFromFloatArray.this.valueIfNonStochastic;
                }
            };
        }
        return new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return RandomVariableFromFloatArray.this.realizations[i];
            }
        };
    }

    public RandomVariable apply(DoubleUnaryOperator operator) {
        if (this.isDeterministic()) {
            return new RandomVariableFromFloatArray(this.time, operator.applyAsDouble(this.valueIfNonStochastic));
        }
        double[] result = new double[this.realizations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = operator.applyAsDouble(this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, result);
    }

    public RandomVariable apply(final DoubleBinaryOperator operator, RandomVariable argument) {
        double newTime = Math.max(this.time, argument.getFiltrationTime());
        if (this.isDeterministic() && argument.isDeterministic()) {
            return new RandomVariableFromFloatArray(newTime, operator.applyAsDouble(this.valueIfNonStochastic, argument.get(0)));
        }
        if (this.isDeterministic() && !argument.isDeterministic()) {
            double[] result = new double[argument.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.valueIfNonStochastic, argument.get(i));
            }
            return new RandomVariableFromFloatArray(newTime, result);
        }
        if (!this.isDeterministic() && argument.isDeterministic()) {
            double[] result = new double[this.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.realizations[i], argument.get(0));
            }
            return new RandomVariableFromFloatArray(newTime, result);
        }
        if (!this.isDeterministic() && !argument.isDeterministic()) {
            double[] result = new double[this.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = operator.applyAsDouble(this.realizations[i], argument.get(i));
            }
            return new RandomVariableFromFloatArray(newTime, result);
        }
        int newSize = Math.max(this.size(), argument.size());
        final IntToDoubleFunction argument0Operator = this.getOperator();
        final IntToDoubleFunction argument1Operator = argument.getOperator();
        IntToDoubleFunction result = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i));
            }
        };
        return new RandomVariableFromFloatArray(newTime, result, newSize);
    }

    public RandomVariable apply(final DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        double newTime = Math.max(this.time, argument1.getFiltrationTime());
        newTime = Math.max(newTime, argument2.getFiltrationTime());
        int newSize = Math.max(Math.max(this.size(), argument1.size()), argument2.size());
        final IntToDoubleFunction argument0Operator = this.getOperator();
        final IntToDoubleFunction argument1Operator = argument1.getOperator();
        final IntToDoubleFunction argument2Operator = argument2.getOperator();
        IntToDoubleFunction result = new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return operator.applyAsDouble(argument0Operator.applyAsDouble(i), argument1Operator.applyAsDouble(i), argument2Operator.applyAsDouble(i));
            }
        };
        return new RandomVariableFromFloatArray(newTime, result, newSize);
    }

    public RandomVariable cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.min(this.realizations[i], (float)cap);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.max(this.realizations[i], (float)floor);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + (float)value;
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] - (float)value;
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * (float)value;
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / (float)value;
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)Math.pow(this.realizations[i], (float)exponent);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable average() {
        return new RandomVariableFromFloatArray(this.getAverage());
    }

    public RandomVariable getConditionalExpectation(ConditionalExpectationEstimator conditionalExpectationOperator) {
        return conditionalExpectationOperator.getConditionalExpectation((RandomVariable)this);
    }

    public RandomVariable squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * this.realizations[i];
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)Math.sqrt(this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariableFromFloatArray exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.exp(this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)Math.exp(this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariableFromFloatArray log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.log(this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)Math.log(this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable sin() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.sin((double)this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)FastMath.sin((double)this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable cos() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.cos((double)this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)FastMath.cos((double)this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable add(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic + (float)randomVariable.get(i);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + (float)randomVariable.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable sub(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.bus((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic - (float)randomVariable.get(i);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] - (float)randomVariable.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable bus(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.sub((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.get(0) - this.valueIfNonStochastic;
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)randomVariable.get(i) - (float)this.valueIfNonStochastic;
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)randomVariable.get(i) - this.realizations[i];
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable mult(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.mult(randomVariable.get(0));
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic * (float)randomVariable.get(i);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * (float)randomVariable.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable div(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.div(randomVariable.get(0));
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic / (float)randomVariable.get(i);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / (float)randomVariable.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable vid(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.div((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.get(0) / this.valueIfNonStochastic;
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)randomVariable.get(i) / (float)this.valueIfNonStochastic;
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)(randomVariable.get(i) / (double)this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable cap(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.cap((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.min((double)this.valueIfNonStochastic, (double)randomVariable.get(0));
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = FastMath.min((float)((float)this.valueIfNonStochastic), (float)((float)randomVariable.get(i)));
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.min((float)this.realizations[i], (float)((float)randomVariable.get(i)));
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable floor(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.floor((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = FastMath.max((double)this.valueIfNonStochastic, (double)randomVariable.get(0));
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)FastMath.max((double)this.valueIfNonStochastic, (double)((float)randomVariable.get(i)));
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = FastMath.max((float)this.realizations[i], (float)((float)randomVariable.get(i)));
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.mult(1.0 + rate.get(0) * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic * (1.0f + (float)rate.get(i) * (float)periodLength);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] * (1.0f + (float)rate.get(i) * (float)periodLength);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable discount(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.div(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), rate.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic / (1.0f + (float)rate.get(i) * (float)periodLength);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), rate.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] / (1.0f + (float)rate.get(i) * (float)periodLength);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        double newTime = this.time;
        newTime = Math.max(newTime, valueIfTriggerNonNegative.getFiltrationTime());
        newTime = Math.max(newTime, valueIfTriggerNegative.getFiltrationTime());
        if (this.isDeterministic()) {
            if (this.valueIfNonStochastic >= 0.0) {
                return valueIfTriggerNonNegative;
            }
            return valueIfTriggerNegative;
        }
        int numberOfPaths = this.size();
        float[] newRealizations = new float[numberOfPaths];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)((double)this.realizations[i] >= 0.0 ? valueIfTriggerNonNegative.get(i) : valueIfTriggerNegative.get(i));
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = 1.0f / this.realizations[i];
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return new RandomVariableFromFloatArray(this.time, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[this.realizations.length];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Math.abs(this.realizations[i]);
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        if (factor1.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, factor1.getFiltrationTime());
        if (factor1.isDeterministic()) {
            return this.add(factor1.get(0) * factor2);
        }
        if (this.isDeterministic() && !factor1.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)this.valueIfNonStochastic + (float)factor1.get(i) * (float)factor2;
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        if (!this.isDeterministic() && factor1.isDeterministic()) {
            float factor1Value = (float)factor1.get(0);
            float[] newRealizations = new float[Math.max(this.size(), factor1.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.realizations[i] + factor1Value * (float)factor2;
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        float[] newRealizations = new float[Math.max(this.size(), factor1.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = this.realizations[i] + (float)factor1.get(i) * (float)factor2;
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        if (factor1.getTypePriority() > this.getTypePriority() || factor2.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(Math.max(this.time, factor1.getFiltrationTime()), factor2.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic() && factor2.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.doubleValue() * factor2.doubleValue();
            return new RandomVariableFromDoubleArray(newTime, newValueIfNonStochastic);
        }
        if (factor1.isDeterministic() && factor2.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2.doubleValue());
        }
        if (factor2.isDeterministic()) {
            return this.addProduct(factor1, factor2.doubleValue());
        }
        if (factor1.isDeterministic()) {
            return this.addProduct(factor2, factor1.doubleValue());
        }
        if (!(this.isDeterministic() || factor1.isDeterministic() || factor2.isDeterministic())) {
            float[] newRealizations = new float[Math.max(Math.max(this.size(), factor1.size()), factor2.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.realizations[i] + (float)factor1.get(i) * (float)factor2.get(i);
            }
            return new RandomVariableFromFloatArray(newTime, newRealizations);
        }
        return this.add(factor1.mult(factor2));
    }

    public RandomVariable addSumProduct(List<RandomVariable> factor1, List<RandomVariable> factor2) {
        RandomVariableFromFloatArray result = this;
        for (int i = 0; i < factor1.size(); ++i) {
            result = result.addProduct(factor1.get(i), factor2.get(i));
        }
        return result;
    }

    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        if (numerator.getTypePriority() > this.getTypePriority() || denominator.getTypePriority() > this.getTypePriority()) {
            return numerator.div(denominator).add((RandomVariable)this);
        }
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + numerator.get(0) / denominator.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)this.get(i) + (float)numerator.get(i) / (float)denominator.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        if (numerator.getTypePriority() > this.getTypePriority() || denominator.getTypePriority() > this.getTypePriority()) {
            return numerator.div(denominator).mult(-1.0).add((RandomVariable)this);
        }
        double newTime = Math.max(Math.max(this.time, numerator.getFiltrationTime()), denominator.getFiltrationTime());
        if (this.isDeterministic() && numerator.isDeterministic() && denominator.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - numerator.get(0) / denominator.get(0);
            return new RandomVariableFromFloatArray(newTime, newValueIfNonStochastic);
        }
        float[] newRealizations = new float[Math.max(Math.max(this.size(), numerator.size()), denominator.size())];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = (float)this.get(i) - (float)numerator.get(i) / (float)denominator.get(i);
        }
        return new RandomVariableFromFloatArray(newTime, newRealizations);
    }

    public RandomVariable isNaN() {
        if (this.isDeterministic()) {
            return new RandomVariableFromFloatArray(this.time, Double.isNaN(this.valueIfNonStochastic) ? 1.0 : 0.0);
        }
        float[] newRealizations = new float[this.size()];
        for (int i = 0; i < newRealizations.length; ++i) {
            newRealizations[i] = Double.isNaN(this.get(i)) ? 1.0f : 0.0f;
        }
        return new RandomVariableFromFloatArray(this.time, newRealizations);
    }

    public String toString() {
        return super.toString() + "\ntime: " + this.time + "\nrealizations: " + (Serializable)(this.isDeterministic() ? Double.valueOf(this.valueIfNonStochastic) : Arrays.toString(this.realizations));
    }
}

