/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.cuda.alternative;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import jcuda.LogLevel;
import jcuda.NativePointerObject;
import jcuda.Pointer;
import jcuda.driver.CUcontext;
import jcuda.driver.CUdevice;
import jcuda.driver.CUdeviceptr;
import jcuda.driver.CUfunction;
import jcuda.driver.CUmodule;
import jcuda.driver.JCudaDriver;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableCudaWithFinalizer
implements RandomVariable {
    private static final long serialVersionUID = 7620120320663270600L;
    private final double time;
    private final CUdeviceptr realizations;
    private final long size;
    private final double valueIfNonStochastic;
    private static final ReferenceQueue<RandomVariableCudaWithFinalizer> referenceQueue = new ReferenceQueue();
    private static final Map<WeakReference<RandomVariableCudaWithFinalizer>, CUdeviceptr> referenceMap = new ConcurrentHashMap<WeakReference<RandomVariableCudaWithFinalizer>, CUdeviceptr>();
    private static final Logger logger = Logger.getLogger("net.finmath");
    public static final CUdevice device;
    public static final CUcontext context;
    private static final CUfunction capByScalar;
    private static final CUfunction floorByScalar;
    private static final CUfunction addScalar;
    private static final CUfunction subScalar;
    private static final CUfunction multScalar;
    private static final CUfunction divScalar;
    private static final CUfunction cuPow;
    private static final CUfunction cuSqrt;
    private static final CUfunction cuExp;
    private static final CUfunction cuLog;
    private static final CUfunction invert;
    private static final CUfunction cuAbs;
    private static final CUfunction cap;
    private static final CUfunction cuFloor;
    private static final CUfunction add;
    private static final CUfunction sub;
    private static final CUfunction mult;
    private static final CUfunction cuDiv;
    private static final CUfunction accrue;
    private static final CUfunction discount;
    private static final CUfunction reducePartial;
    private static final int reduceGridSize = 1024;

    public RandomVariableCudaWithFinalizer(double time, CUdeviceptr realizations, long size) {
        this.time = time;
        this.realizations = realizations;
        this.size = size;
        this.valueIfNonStochastic = Double.NaN;
        WeakReference<RandomVariableCudaWithFinalizer> reference = new WeakReference<RandomVariableCudaWithFinalizer>(this, referenceQueue);
        referenceMap.put(reference, realizations);
    }

    public RandomVariableCudaWithFinalizer(double value) {
        this(-1.7976931348623157E308, value);
    }

    public RandomVariableCudaWithFinalizer(double time, double value) {
        this.time = time;
        this.realizations = null;
        this.size = 1L;
        this.valueIfNonStochastic = value;
    }

    public RandomVariableCudaWithFinalizer(double time, float[] realisations) {
        this.time = time;
        this.size = realisations.length;
        this.realizations = this.createCUdeviceptr(realisations);
        this.valueIfNonStochastic = Double.NaN;
    }

    public RandomVariableCudaWithFinalizer(double time, double[] realisations) {
        this(time, RandomVariableCudaWithFinalizer.getFloatArray(realisations));
    }

    private CUdeviceptr createCUdeviceptr(long size) {
        CUdeviceptr cuDevicePtr = RandomVariableCudaWithFinalizer.getCUdeviceptr(size);
        return cuDevicePtr;
    }

    public static CUdeviceptr getCUdeviceptr(long size) {
        CUdeviceptr cuDevicePtr = new CUdeviceptr();
        int succ = JCudaDriver.cuMemAlloc((CUdeviceptr)cuDevicePtr, (long)(size * 4L));
        if (succ != 0) {
            cuDevicePtr = null;
            logger.finest("Failed creating device vector " + cuDevicePtr + " with size=" + size);
        } else {
            logger.finest("Creating device vector " + cuDevicePtr + " with size=" + size);
        }
        return cuDevicePtr;
    }

    private CUdeviceptr createCUdeviceptr(float[] values) {
        CUdeviceptr cuDevicePtr = this.createCUdeviceptr(values.length);
        JCudaDriver.cuMemcpyHtoD((CUdeviceptr)cuDevicePtr, (Pointer)Pointer.to((float[])values), (long)((long)values.length * 4L));
        return cuDevicePtr;
    }

    protected void finalize() throws Throwable {
        System.out.println("Finalizing " + this.realizations);
        if (this.realizations != null) {
            JCudaDriver.cuMemFree((CUdeviceptr)this.realizations);
        }
        super.finalize();
    }

    private static float[] getFloatArray(double[] arrayOfDouble) {
        float[] arrayOfFloat = new float[arrayOfDouble.length];
        for (int i = 0; i < arrayOfDouble.length; ++i) {
            arrayOfFloat[i] = (float)arrayOfDouble[i];
        }
        return arrayOfFloat;
    }

    private static double[] getDoubleArray(float[] arrayOfFloat) {
        double[] arrayOfDouble = new double[arrayOfFloat.length];
        for (int i = 0; i < arrayOfFloat.length; ++i) {
            arrayOfDouble[i] = arrayOfFloat[i];
        }
        return arrayOfDouble;
    }

    public boolean equals(RandomVariable randomVariable) {
        throw new UnsupportedOperationException();
    }

    public double getFiltrationTime() {
        return this.time;
    }

    public int getTypePriority() {
        return 20;
    }

    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException();
    }

    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return (int)this.size;
    }

    public double getMin() {
        throw new UnsupportedOperationException();
    }

    public double getMax() {
        throw new UnsupportedOperationException();
    }

    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.reduce() / (double)this.size();
    }

    public double getAverage(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        return this.squared().getAverage() - average * average;
    }

    public double getVariance(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    public double getQuantile(double quantile) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new UnsupportedOperationException();
    }

    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        throw new UnsupportedOperationException();
    }

    public double[] getHistogram(double[] intervalPoints) {
        throw new UnsupportedOperationException();
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        throw new UnsupportedOperationException();
    }

    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariable expand(int numberOfPaths) {
        if (this.isDeterministic()) {
            float[] clone = new float[numberOfPaths];
            Arrays.fill(clone, (float)this.valueIfNonStochastic);
            return new RandomVariableCudaWithFinalizer(this.time, clone);
        }
        return this;
    }

    public RandomVariable cache() {
        return this;
    }

    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.get(0)};
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleUnaryOperator function) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(capByScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)cap}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(floorByScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)floor}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(addScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)value}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(subScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)value}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(multScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)value}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(divScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)value}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(cuPow, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((float[])new float[]{(float)exponent}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        return this.mult(this);
    }

    public RandomVariable sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(cuSqrt, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariableCudaWithFinalizer exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.exp(this.valueIfNonStochastic);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(cuExp, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariableCudaWithFinalizer log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.log(this.valueIfNonStochastic);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(cuLog, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable sin() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cos() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable add(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.get(0);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.add((RandomVariable)this);
        }
        CUdeviceptr result = this.callCudaFunction(add, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable sub(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.get(0);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic - randomVariable.get(i);
            }
            return new RandomVariableCudaWithFinalizer(newTime, newRealizations);
        }
        CUdeviceptr result = this.callCudaFunction(sub, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable mult(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.get(0);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            float[] newRealizations = new float[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = (float)(this.valueIfNonStochastic * randomVariable.get(i));
            }
            return new RandomVariableCudaWithFinalizer(newTime, newRealizations);
        }
        CUdeviceptr result = this.callCudaFunction(mult, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable div(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.get(0);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            double[] newRealizations = new double[Math.max(this.size(), randomVariable.size())];
            for (int i = 0; i < newRealizations.length; ++i) {
                newRealizations[i] = this.valueIfNonStochastic / randomVariable.get(i);
            }
            return new RandomVariableCudaWithFinalizer(newTime, newRealizations);
        }
        CUdeviceptr result = this.callCudaFunction(cuDiv, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(invert, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return new RandomVariableCudaWithFinalizer(this.time, newValueIfNonStochastic);
        }
        CUdeviceptr result = this.callCudaFunction(cuAbs, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable cap(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, randomVariable.get(0));
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.cap((RandomVariable)this);
        }
        CUdeviceptr result = this.callCudaFunction(cap, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable floor(RandomVariable randomVariable) {
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, randomVariable.get(0));
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.floor((RandomVariable)this);
        }
        CUdeviceptr result = this.callCudaFunction(cuFloor, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)randomVariable).realizations}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (this.isDeterministic() && rate.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * (1.0 + rate.get(0) * periodLength);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            return rate.mult(periodLength * this.valueIfNonStochastic).add(this.valueIfNonStochastic);
        }
        if (!this.isDeterministic() && rate.isDeterministic()) {
            double rateValue = rate.get(0);
            return this.mult(1.0 + rateValue * periodLength);
        }
        CUdeviceptr result = this.callCudaFunction(accrue, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)rate).realizations}), Pointer.to((float[])new float[]{(float)periodLength}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public RandomVariable discount(RandomVariable rate, double periodLength) {
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (this.isDeterministic() && rate.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / (1.0 + rate.get(0) * periodLength);
            return new RandomVariableCudaWithFinalizer(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            if (this.valueIfNonStochastic == 0.0) {
                return this;
            }
            return rate.mult(periodLength / this.valueIfNonStochastic).add(1.0 / this.valueIfNonStochastic).invert();
        }
        if (!this.isDeterministic() && rate.isDeterministic()) {
            double rateValue = rate.get(0);
            return this.div(1.0 + rateValue * periodLength);
        }
        CUdeviceptr result = this.callCudaFunction(discount, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{((RandomVariableCudaWithFinalizer)rate).realizations}), Pointer.to((float[])new float[]{(float)periodLength}), new Pointer()});
        return new RandomVariableCudaWithFinalizer(this.time, result, this.size());
    }

    public Double doubleValue() {
        return null;
    }

    public IntToDoubleFunction getOperator() {
        return null;
    }

    public DoubleStream getRealizationsStream() {
        return null;
    }

    public RandomVariable average() {
        return null;
    }

    public RandomVariable bus(RandomVariable randomVariable) {
        return null;
    }

    public RandomVariable vid(RandomVariable randomVariable) {
        return null;
    }

    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return null;
    }

    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        return null;
    }

    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        return null;
    }

    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return null;
    }

    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return null;
    }

    public RandomVariable isNaN() {
        return null;
    }

    private double reduce() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        RandomVariableCudaWithFinalizer reduced = this;
        while (reduced.size() > 1) {
            reduced = reduced.reduceBySize(1024);
        }
        return reduced.getRealizations()[0];
    }

    private RandomVariableCudaWithFinalizer reduceBySize(int bySize) {
        int blockSizeX = bySize;
        int gridSizeX = (int)Math.ceil((double)this.size() / 2.0 / (double)blockSizeX);
        CUdeviceptr reduceVector = RandomVariableCudaWithFinalizer.getCUdeviceptr(gridSizeX);
        this.callCudaFunction(reducePartial, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations}), Pointer.to((NativePointerObject[])new NativePointerObject[]{reduceVector})}, gridSizeX, blockSizeX, blockSizeX);
        return new RandomVariableCudaWithFinalizer(0.0, reduceVector, gridSizeX);
    }

    private CUdeviceptr callCudaFunction(CUfunction function, Pointer[] arguments) {
        CUdeviceptr result = RandomVariableCudaWithFinalizer.getCUdeviceptr(this.size());
        arguments[arguments.length - 1] = Pointer.to((NativePointerObject[])new NativePointerObject[]{result});
        int blockSizeX = 256;
        int gridSizeX = (int)Math.ceil((double)this.size() / 256.0);
        this.callCudaFunction(function, arguments, gridSizeX, 256, 0);
        return result;
    }

    private CUdeviceptr callCudaFunction(CUfunction function, Pointer[] arguments, int gridSizeX, int blockSizeX, int sharedMemorySize) {
        CUdeviceptr result = RandomVariableCudaWithFinalizer.getCUdeviceptr(this.size());
        arguments[arguments.length - 1] = Pointer.to((NativePointerObject[])new NativePointerObject[]{result});
        Pointer kernelParameters = Pointer.to((NativePointerObject[])arguments);
        JCudaDriver.cuLaunchKernel((CUfunction)function, (int)gridSizeX, (int)1, (int)1, (int)blockSizeX, (int)1, (int)1, (int)sharedMemorySize, null, (Pointer)kernelParameters, null);
        JCudaDriver.cuCtxSynchronize();
        return result;
    }

    private static String preparePtxFile(String cuFileName) throws IOException {
        String ptxFileName;
        File ptxFile;
        int endIndex = cuFileName.lastIndexOf(46);
        if (endIndex == -1) {
            endIndex = cuFileName.length() - 1;
        }
        if ((ptxFile = new File(ptxFileName = cuFileName.substring(0, endIndex + 1) + "ptx")).exists()) {
            return ptxFileName;
        }
        File cuFile = new File(cuFileName);
        if (!cuFile.exists()) {
            throw new IOException("Input file not found: " + cuFileName);
        }
        String modelString = "-m" + System.getProperty("sun.arch.data.model");
        String command = "nvcc " + modelString + " -ptx " + cuFile.getPath() + " -o " + ptxFileName;
        System.out.println("Executing\n" + command);
        Process process = Runtime.getRuntime().exec(command);
        String errorMessage = new String(RandomVariableCudaWithFinalizer.toByteArray(process.getErrorStream()));
        String outputMessage = new String(RandomVariableCudaWithFinalizer.toByteArray(process.getInputStream()));
        int exitValue = 0;
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for nvcc output", e);
        }
        if (exitValue != 0) {
            System.out.println("nvcc process exitValue " + exitValue);
            System.out.println("errorMessage:\n" + errorMessage);
            System.out.println("outputMessage:\n" + outputMessage);
            throw new IOException("Could not create .ptx file: " + errorMessage);
        }
        System.out.println("Finished creating PTX file");
        return ptxFileName;
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    static {
        JCudaDriver.setExceptionsEnabled((boolean)true);
        JCudaDriver.setLogLevel((LogLevel)LogLevel.LOG_DEBUG);
        String ptxFileName = null;
        try {
            ptxFileName = RandomVariableCudaWithFinalizer.preparePtxFile("RandomVariableCudaKernel.cu");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JCudaDriver.cuInit((int)0);
        device = new CUdevice();
        JCudaDriver.cuDeviceGet((CUdevice)device, (int)0);
        context = new CUcontext();
        JCudaDriver.cuCtxCreate((CUcontext)context, (int)0, (CUdevice)device);
        CUmodule module = new CUmodule();
        JCudaDriver.cuModuleLoad((CUmodule)module, (String)ptxFileName);
        capByScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)capByScalar, (CUmodule)module, (String)"capByScalar");
        floorByScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)floorByScalar, (CUmodule)module, (String)"floorByScalar");
        addScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)addScalar, (CUmodule)module, (String)"addScalar");
        subScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)subScalar, (CUmodule)module, (String)"subScalar");
        multScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)multScalar, (CUmodule)module, (String)"multScalar");
        divScalar = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)divScalar, (CUmodule)module, (String)"divScalar");
        cuPow = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuPow, (CUmodule)module, (String)"cuPow");
        cuSqrt = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuSqrt, (CUmodule)module, (String)"cuSqrt");
        cuExp = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuExp, (CUmodule)module, (String)"cuExp");
        cuLog = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuLog, (CUmodule)module, (String)"cuLog");
        invert = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)invert, (CUmodule)module, (String)"invert");
        cuAbs = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuAbs, (CUmodule)module, (String)"cuAbs");
        cap = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cap, (CUmodule)module, (String)"cap");
        cuFloor = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuFloor, (CUmodule)module, (String)"cuFloor");
        add = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)add, (CUmodule)module, (String)"add");
        sub = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)sub, (CUmodule)module, (String)"sub");
        mult = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)mult, (CUmodule)module, (String)"mult");
        cuDiv = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)cuDiv, (CUmodule)module, (String)"cuDiv");
        accrue = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)accrue, (CUmodule)module, (String)"accrue");
        discount = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)accrue, (CUmodule)module, (String)"discount");
        reducePartial = new CUfunction();
        JCudaDriver.cuModuleGetFunction((CUfunction)reducePartial, (CUmodule)module, (String)"reducePartial");
    }
}

