/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.cuda.alternative;

import java.io.Serializable;
import java.util.Random;
import net.finmath.functions.NormalDistribution;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class BrownianMotionJavaRandom
implements BrownianMotion,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private transient RandomVariable[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianMotionJavaRandom(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, AbstractRandomVariableFactory randomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.randomVariableFactory = randomVariableFactory;
        this.brownianIncrements = null;
    }

    public BrownianMotionJavaRandom(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, seed, (AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionJavaRandom(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), seed);
    }

    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianMotionJavaRandom(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        int factor;
        int timeIndex;
        if (this.brownianIncrements != null) {
            return;
        }
        Random random = new Random(this.seed);
        double[][][] brownianIncrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        double[] sqrtOfTimeStep = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (timeIndex = 0; timeIndex < sqrtOfTimeStep.length; ++timeIndex) {
            sqrtOfTimeStep[timeIndex] = Math.sqrt(this.timeDiscretization.getTimeStep(timeIndex));
        }
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double sqrtDeltaT = sqrtOfTimeStep[timeIndex];
            for (factor = 0; factor < this.numberOfFactors; ++factor) {
                double[] randomVariableValues = brownianIncrementsArray[timeIndex][factor];
                for (int path = 0; path < this.numberOfPaths; ++path) {
                    double uniformIncrement = random.nextDouble();
                    randomVariableValues[path] = NormalDistribution.inverseCumulativeDistribution((double)uniformIncrement) * sqrtDeltaT;
                }
            }
        }
        this.brownianIncrements = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (factor = 0; factor < this.numberOfFactors; ++factor) {
                this.brownianIncrements[timeIndex][factor] = this.randomVariableFactory.createRandomVariable(time, brownianIncrementsArray[timeIndex][factor]);
            }
        }
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretizationFromArray: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nseed: " + this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrownianMotionJavaRandom that = (BrownianMotionJavaRandom)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.seed;
        return result;
    }
}

